package org.palladiosimulator.solver.core.handler;

import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;

import org.palladiosimulator.solver.context.computed_usage.BranchProbability;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public abstract class AbstractBranchTransitionHandler {

	private static Logger logger = Logger.getLogger(AbstractBranchTransitionHandler.class.getName());

	protected ComputedUsageFactory usageFactory = ComputedUsageFactory.eINSTANCE;

	
	protected SeffVisitor visitor;

	/**
	 * @param context
	 * @param _visitor
	 * @param nextHandler
	 */
	public AbstractBranchTransitionHandler(SeffVisitor seffVisitor) {
		visitor = seffVisitor;
	}
	
	/**
	 * @param bt
	 */
	protected void visitChildBehaviour(AbstractBranchTransition bt) {
		ResourceDemandingBehaviour rdb = bt
				.getBranchBehaviour_BranchTransition();
		if (rdb != null){
			visitor.doSwitch(rdb);
		}
	}

	/**
	 * @param bt
	 * @param solvedBranchProb
	 */
	protected void storeToUsageContext(AbstractBranchTransition bt, double solvedBranchProb) {
		BranchProbability prob = usageFactory.createBranchProbability();
		prob.setBranchtransition_BranchProbability(bt);
		prob.setProbability(solvedBranchProb);

		visitor.getContextWrapper().getCompUsgCtx().getBranchProbabilities_ComputedUsageContext().add(prob);
	}
}
