/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.core.handler.ExternalCallActionHandler;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.AggregatedContextSEFFVisitor;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class AggregatedContextExternalCallActionHandler
extends ExternalCallActionHandler {
    private double frequency;
    private UsageScenario usageScenario;
    private ServiceEffectSpecification calledSEFF;
    private AssemblyContext calledAssemblyCtxt;
    private AllocationContext calledAllocationContext;

    public AggregatedContextExternalCallActionHandler(AggregatedContextSEFFVisitor seffVisitor, UsageScenario usageScenario) {
        super(seffVisitor);
        this.frequency = seffVisitor.getCurrentFrequency();
        this.usageScenario = usageScenario;
    }

    @Override
    protected SeffVisitor visitSEFF(ServiceEffectSpecification seff, ContextWrapper contextWrapper) {
        AggregatedContextSEFFVisitor seffVisitor = new AggregatedContextSEFFVisitor(contextWrapper, this.frequency, seff, this.usageScenario);
        this.calledSEFF = seff;
        this.calledAssemblyCtxt = contextWrapper.getAssCtx();
        this.calledAllocationContext = contextWrapper.getAllCtx();
        seffVisitor.doSwitch((EObject)seff);
        return seffVisitor;
    }

    public ServiceEffectSpecification getCalledSEFF() {
        return this.calledSEFF;
    }

    public AssemblyContext getCalledAssemblyCtxt() {
        return this.calledAssemblyCtxt;
    }

    public AllocationContext getCalledAllocationContext() {
        return this.calledAllocationContext;
    }
}

