/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.solver.core.handler.AbstractLoopActionHandler;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class LoopActionHandler
extends AbstractLoopActionHandler {
    private static Logger logger = Logger.getLogger((String)LoopActionHandler.class.getName());

    public LoopActionHandler(SeffVisitor seffVisitor) {
        super(seffVisitor);
    }

    public void handle(LoopAction loop) {
        String specification = loop.getIterationCount_LoopAction().getSpecification();
        String solvedSpecification = ExpressionHelper.getSolvedExpressionAsString(specification, this.visitor.getContextWrapper());
        if (solvedSpecification == null) {
            logger.error((Object)"Could not determine iterations specification. Skipping execution of loop body!");
            return;
        }
        logger.debug((Object)("NumberOfIterations: " + solvedSpecification));
        this.storeToUsageContext((AbstractLoopAction)loop, solvedSpecification);
        this.visitLoopBody((AbstractLoopAction)loop, solvedSpecification);
    }
}

