/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.context.computed_usage.LoopIteration;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public abstract class AbstractLoopActionHandler {
    private static Logger logger = Logger.getLogger((String)AbstractLoopActionHandler.class.getName());
    protected ComputedUsageFactory usageFactory = ComputedUsageFactory.eINSTANCE;
    protected SeffVisitor visitor;

    public AbstractLoopActionHandler(SeffVisitor seffVisitor) {
        this.visitor = seffVisitor;
    }

    protected void visitLoopBody(AbstractLoopAction loop, String iterationCountSpecification) {
        Expression solvedIterationCountExpr = ExpressionHelper.parseToExpression(iterationCountSpecification);
        ResourceDemandingBehaviour loopBody = loop.getBodyBehaviour_Loop();
        if (loopBody != null) {
            this.visitor.doSwitch((EObject)loopBody);
        }
    }

    public int getUpperBound(Expression solvedLoopCountExpr) {
        int upperBound = 0;
        if (solvedLoopCountExpr instanceof IntLiteral) {
            IntLiteral loopInt = (IntLiteral)solvedLoopCountExpr;
            upperBound = loopInt.getValue();
        } else if (solvedLoopCountExpr instanceof ProbabilityFunctionLiteral) {
            ProbabilityFunctionLiteral loopProbLiteral = (ProbabilityFunctionLiteral)solvedLoopCountExpr;
            if (loopProbLiteral.getFunction_ProbabilityFunctionLiteral() instanceof ProbabilityMassFunction) {
                ProbabilityMassFunction loopPMF = (ProbabilityMassFunction)loopProbLiteral.getFunction_ProbabilityFunctionLiteral();
                EList sampleList = loopPMF.getSamples();
                Sample lastSample = (Sample)sampleList.get(sampleList.size() - 1);
                if (lastSample.getValue() instanceof Integer) {
                    upperBound = (Integer)lastSample.getValue();
                } else {
                    logger.error((Object)"Could not determine upper bound for executing loop (PMF for loop count does not contain integer values). Skipping execution of loop body.");
                }
            } else {
                logger.error((Object)"Could not determine upper bound for executing loop (loop count is prob function, but not PMF).Skipping execution of loop body.");
            }
        } else {
            logger.error((Object)"Could not determine upper bound for executing loop (loop count neither Integer nor PMF). Skipping execution of loop body.");
        }
        return upperBound;
    }

    protected void storeToUsageContext(AbstractLoopAction loop, String solvedSpecification) {
        LoopIteration loopIteration = this.usageFactory.createLoopIteration();
        loopIteration.setLoopaction_LoopIteration(loop);
        PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rv.setSpecification(solvedSpecification);
        loopIteration.setSpecification_LoopIteration(rv);
        this.visitor.getContextWrapper().getCompUsgCtx().getLoopiterations_ComputedUsageContext().add((Object)loopIteration);
    }
}

