/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.handler;

import de.uka.ipd.sdq.stoex.Expression;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationFactory;
import org.palladiosimulator.solver.context.computed_allocation.ResourceDemand;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.core.visitors.SeffVisitor;

public class InternalActionHandler {
    private static Logger logger = Logger.getLogger((String)InternalActionHandler.class.getName());
    private ComputedAllocationFactory compAllocationFactory = ComputedAllocationFactory.eINSTANCE;
    private SeffVisitor visitor;

    public InternalActionHandler(SeffVisitor seffVisitor) {
        this.visitor = seffVisitor;
    }

    public void handle(InternalAction action) {
        for (ParametricResourceDemand prd : action.getResourceDemand_Action()) {
            ProcessingResourceType requiredResourceType = prd.getRequiredResource_ParametricResourceDemand();
            if (requiredResourceType.getEntityName().equals("SystemExternalResource")) {
                EList resConList = this.visitor.getContextWrapper().getPcmInstance().getResourceEnvironment().getResourceContainer_ResourceEnvironment();
                for (ResourceContainer resCon : resConList) {
                    if (!resCon.getEntityName().equals("SystemExternalResourceContainer")) continue;
                    ProcessingResourceSpecification prs = (ProcessingResourceSpecification)resCon.getActiveResourceSpecifications_ResourceContainer().get(0);
                    this.createActualResourceDemand(action, prd, prs);
                }
                continue;
            }
            EList<ProcessingResourceSpecification> resourceList = this.getResourceList();
            for (ProcessingResourceSpecification prs : resourceList) {
                ProcessingResourceType currentResourceType = prs.getActiveResourceType_ActiveResourceSpecification();
                if (!currentResourceType.getEntityName().equals(requiredResourceType.getEntityName())) continue;
                this.createActualResourceDemand(action, prd, prs);
            }
        }
    }

    protected void createActualResourceDemand(InternalAction action, ParametricResourceDemand prd, ProcessingResourceSpecification prs) {
        String spec = prd.getSpecification_ParametericResourceDemand().getSpecification();
        spec = "(" + spec + ") / ((" + prs.getProcessingRate_ProcessingResourceSpecification().getSpecification() + ")*1.0)";
        logger.debug((Object)("Actual Resource Demand (Expression): " + spec));
        String actResDemSpecification = this.getSolvedResourceDemandSpecification(spec);
        ResourceDemand ard = this.compAllocationFactory.createResourceDemand();
        ard.setParametricResourceDemand_ResourceDemand(prd);
        PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rv.setSpecification(actResDemSpecification);
        ard.setSpecification_ResourceDemand(rv);
        this.visitor.getContextWrapper().getCompAllCtx().getResourceDemands_ComputedAllocationContext().add((Object)ard);
    }

    protected String getSolvedResourceDemandSpecification(String specification) {
        Expression solvedExpr = ExpressionHelper.getSolvedExpression(specification, this.visitor.getContextWrapper());
        String solvedSpecification = ExpressionHelper.getSolvedExpressionAsString(specification, this.visitor.getContextWrapper());
        logger.debug((Object)("Computed Actual Resource Demand: " + solvedSpecification));
        return solvedSpecification;
    }

    private EList<ProcessingResourceSpecification> getResourceList() {
        AllocationContext ac = this.visitor.getContextWrapper().getAllCtx();
        ResourceContainer currentResourceContainer = ac.getResourceContainer_AllocationContext();
        EList resourceList = currentResourceContainer.getActiveResourceSpecifications_ResourceContainer();
        return resourceList;
    }
}

