/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.core.transformations;

import de.uka.ipd.sdq.probfunction.ContinuousPDF;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IContinousPDF;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NumericLiteral;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.analyser.probfunction.ProbfunctionHelper;
import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.stoex.api.StoExSerialiser;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;

public class ExpressionToPDFWrapper {
    ProbabilityDensityFunction pdf;
    Double meanValue;
    Double standardDeviation;
    boolean originalPDF;
    protected static final StoExSerialiser STOEX_SERIALISER = StoExSerialiser.createInstance();
    protected static final Logger LOGGER = Logger.getLogger((String)"org.palladiosimulator.solver.transformations");

    public ExpressionToPDFWrapper(ProbabilityDensityFunction pdf) {
        this.pdf = pdf;
        this.originalPDF = true;
    }

    public static ExpressionToPDFWrapper createExpressionToPDFWrapper(Expression rdExpression) {
        if (rdExpression instanceof ProbabilityFunctionLiteral) {
            ProbabilityFunctionLiteral probFuncLit = (ProbabilityFunctionLiteral)rdExpression;
            ProbabilityFunction pf = probFuncLit.getFunction_ProbabilityFunctionLiteral();
            if (pf instanceof ProbabilityMassFunction) {
                ProbabilityMassFunction pmf = (ProbabilityMassFunction)pf;
                ManagedPMF managedPmf = new ManagedPMF(pmf);
                double value = managedPmf.getExpectedValueDouble();
                return new ExpressionToPDFWrapper(value);
            }
            ProbabilityDensityFunction pdf = (ProbabilityDensityFunction)pf;
            return new ExpressionToPDFWrapper(pdf);
        }
        if (rdExpression instanceof FunctionLiteral) {
            FunctionLiteral fLit = (FunctionLiteral)rdExpression;
            ContinuousPDF pdf = ProbfunctionHelper.createFunction((List)fLit.getParameters_FunctionLiteral(), (String)fLit.getId(), (ProbfunctionFactory)ProbfunctionFactory.eINSTANCE);
            return new ExpressionToPDFWrapper((ProbabilityDensityFunction)pdf);
        }
        if (rdExpression instanceof NumericLiteral) {
            Double value = ExpressionToPDFWrapper.getDoubleValueForNumericLiteral((NumericLiteral)rdExpression);
            return new ExpressionToPDFWrapper(value);
        }
        String solvedExprString = null;
        if (rdExpression != null) {
            try {
                Expression solvedExpression = ExpressionHelper.getSolvedExpression(rdExpression, null);
                String oldExpressionString = STOEX_SERIALISER.serialise(rdExpression);
                solvedExprString = STOEX_SERIALISER.serialise(solvedExpression);
                if (!oldExpressionString.equals(solvedExprString)) {
                    return ExpressionToPDFWrapper.createExpressionToPDFWrapper(solvedExpression);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Handling expression " + solvedExprString + " in the ResourceDemandWrapper failed, could not solve it. Note that it must not contain parameters as there is no context to solve them against.", e);
            }
        }
        throw new IllegalArgumentException("Handling expression " + solvedExprString + " in the ResourceDemandWrapper failed, could not cast it to " + ProbabilityFunctionLiteral.class + " or " + FunctionLiteral.class);
    }

    public ExpressionToPDFWrapper(Double meanValue) {
        this.meanValue = meanValue;
        this.standardDeviation = new Double(0.0);
        this.originalPDF = false;
    }

    public ProbabilityDensityFunction getPDF() {
        if (this.pdf == null && this.meanValue != null) {
            ProbabilityDensityFunction pdfLit;
            this.pdf = pdfLit = this.convertLiteralsToPDFs(this.meanValue);
        }
        return this.pdf;
    }

    public Double getMeanValue() {
        if (this.meanValue == null && this.pdf != null) {
            ManagedPDF mpdf = new ManagedPDF(this.pdf);
            try {
                Double value;
                this.meanValue = value = new Double(mpdf.getPdfTimeDomain().getArithmeticMeanValue());
            }
            catch (DomainNotNumbersException e) {
                ContextWrapper.logger.error((Object)"Error calculating arithmetic mean value.", (Throwable)e);
                e.printStackTrace();
            }
            catch (FunctionNotInTimeDomainException e) {
                ContextWrapper.logger.error((Object)"Error calculating arithmetic mean value.", (Throwable)e);
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("Could not get mean value of PDF " + this.pdf.toString()));
                throw e;
            }
        }
        return this.meanValue;
    }

    public Double getStandardDeviation() {
        if (this.standardDeviation == null && this.pdf != null) {
            ManagedPDF mpdf = new ManagedPDF(this.pdf);
            try {
                Double stdev;
                IProbabilityDensityFunction probFunction = mpdf.getPdfTimeDomain();
                this.standardDeviation = probFunction instanceof IContinousPDF ? (stdev = new Double(((IContinousPDF)probFunction).getStandardDeviation())) : Double.valueOf(Double.NaN);
            }
            catch (DomainNotNumbersException e) {
                ContextWrapper.logger.error((Object)"Error calculating arithmetic mean value.", (Throwable)e);
                e.printStackTrace();
            }
            catch (FunctionNotInTimeDomainException e) {
                ContextWrapper.logger.error((Object)"Error calculating arithmetic mean value.", (Throwable)e);
                e.printStackTrace();
            }
        }
        return this.standardDeviation;
    }

    private ProbabilityDensityFunction convertLiteralsToPDFs(Double demand) {
        double distance = 0.1;
        try {
            distance = PDFConfiguration.getCurrentConfiguration().getDistance();
        }
        catch (ConfigurationNotSetException e) {
            e.printStackTrace();
            throw new RuntimeException("Converting literal to pdf failed, wring initialisation. ", e);
        }
        if (demand > 0.0 && distance > 0.0) {
            while (demand - distance <= 0.0) {
                distance /= 10.0;
            }
        }
        Double firstValue = new Double(demand - distance);
        String newDemand = "DoublePDF[(" + firstValue.toString() + ";0.0)(" + demand + ";1.0)(" + new Double(demand + distance).toString() + ";0.0)]";
        PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rv.setSpecification(newDemand);
        ProbabilityFunctionLiteral exp = (ProbabilityFunctionLiteral)rv.getExpression();
        return (ProbabilityDensityFunction)exp.getFunction_ProbabilityFunctionLiteral();
    }

    public boolean isOriginalPDF() {
        return this.originalPDF;
    }

    private static Double getDoubleValueForNumericLiteral(NumericLiteral rdExpression) {
        double value = 0.0;
        if (rdExpression instanceof DoubleLiteral) {
            value = ((DoubleLiteral)rdExpression).getValue();
        } else if (rdExpression instanceof IntLiteral) {
            value = ((IntLiteral)rdExpression).getValue();
        } else {
            throw new RuntimeException("Unknown type of numeric literal: " + rdExpression.getClass());
        }
        return value;
    }
}

