/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.lqn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulingType implements Enumerator
{
    FCFS(0, "fcfs", "fcfs"),
    PS(1, "ps", "ps"),
    PP(2, "pp", "pp"),
    INF(3, "inf", "inf"),
    RAND(4, "rand", "rand"),
    HOL(5, "hol", "hol"),
    PS_HOL(6, "psHol", "ps-hol"),
    PS_PP(7, "psPp", "ps-pp"),
    CFS(8, "cfs", "cfs");

    public static final int FCFS_VALUE = 0;
    public static final int PS_VALUE = 1;
    public static final int PP_VALUE = 2;
    public static final int INF_VALUE = 3;
    public static final int RAND_VALUE = 4;
    public static final int HOL_VALUE = 5;
    public static final int PS_HOL_VALUE = 6;
    public static final int PS_PP_VALUE = 7;
    public static final int CFS_VALUE = 8;
    private static final SchedulingType[] VALUES_ARRAY;
    public static final List<SchedulingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulingType[]{FCFS, PS, PP, INF, RAND, HOL, PS_HOL, PS_PP, CFS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingType get(int value) {
        switch (value) {
            case 0: {
                return FCFS;
            }
            case 1: {
                return PS;
            }
            case 2: {
                return PP;
            }
            case 3: {
                return INF;
            }
            case 4: {
                return RAND;
            }
            case 5: {
                return HOL;
            }
            case 6: {
                return PS_HOL;
            }
            case 7: {
                return PS_PP;
            }
            case 8: {
                return CFS;
            }
        }
        return null;
    }

    private SchedulingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

