/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.palladiosimulator.solver.core.Pair;
import org.palladiosimulator.solver.lqn.DocumentRoot;
import org.palladiosimulator.solver.lqn.LqnFactory;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.lqn.LqnPackage;

public class LqnXmlHandler {
    private static Logger logger = Logger.getLogger((String)LqnXmlHandler.class.getName());
    LqnModelType lqnModel;

    public LqnXmlHandler(LqnModelType anLqnModel) {
        this.lqnModel = anLqnModel;
    }

    protected EObject createInitialModel() {
        LqnPackage lqnPackage = LqnPackage.eINSTANCE;
        LqnFactory lqnFactory = lqnPackage.getLqnFactory();
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)lqnPackage);
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("lqnModel");
        EObject rootObject = lqnFactory.create(eClass);
        rootObject.eSet(eStructuralFeature, (Object)EcoreUtil.create((EClass)((EClass)eStructuralFeature.getEType())));
        return rootObject;
    }

    public void saveModelToXMI(String fileName) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)new File(fileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        DocumentRoot rootObject = (DocumentRoot)this.createInitialModel();
        rootObject.setLqnModel(this.lqnModel);
        resource.getContents().add((Object)rootObject);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static LqnModelType loadModelFromXMI(String fileName) {
        ArrayList<Pair<String, String>> stringsToReplace = new ArrayList<Pair<String, String>>(7);
        stringsToReplace.add(new Pair((Object)"-1.#IND", (Object)"-1"));
        stringsToReplace.add(new Pair((Object)"1.#INF", (Object)"Infinity"));
        stringsToReplace.add(new Pair((Object)"proc-waiting=\"inf\"", (Object)"proc-waiting=\"Infinity\""));
        stringsToReplace.add(new Pair((Object)"service-time=\"inf\"", (Object)"service-time=\"Infinity\""));
        stringsToReplace.add(new Pair((Object)"utilization=\"inf\"", (Object)"utilization=\"Infinity\""));
        stringsToReplace.add(new Pair((Object)"squared-coeff-variation=\"inf\"", (Object)"squared-coeff-variation=\"Infinity\""));
        stringsToReplace.add(new Pair((Object)"service-time-variance=\"inf\"", (Object)"service-time-variance=\"Infinity\""));
        LqnXmlHandler.replaceInXMLFile(fileName, stringsToReplace);
        LqnModelType lqnModel = null;
        try {
            Resource resource = LqnXmlHandler.loadIntoResourceSet(fileName);
            DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
            lqnModel = documentRoot.getLqnModel();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return lqnModel;
    }

    private static Resource loadIntoResourceSet(String fileName) throws IOException {
        URI fileURI = URI.createFileURI((String)new File(fileName).getAbsolutePath());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(Collections.EMPTY_MAP);
        return resource;
    }

    public static void fixXMLFile(String filename) {
        LqnXmlHandler.replaceInXMLFile(filename, "xml version=\"1.0\" encoding=\"ASCII\"", "xml version=\"1.0\" encoding=\"us-ascii\"");
    }

    private static void replaceInXMLFile(String filename, ArrayList<Pair<String, String>> stringsToReplace) {
        String content = LqnXmlHandler.readContentFromFile(filename);
        for (Pair<String, String> pair : stringsToReplace) {
            content = content.replaceAll((String)pair.getFirst(), (String)pair.getSecond());
        }
        LqnXmlHandler.writeContentToFile(filename, content);
    }

    private static void replaceInXMLFile(String filename, String regexToMatch, String replacement) {
        ArrayList<Pair<String, String>> stringsToReplace = new ArrayList<Pair<String, String>>(1);
        stringsToReplace.add(new Pair((Object)regexToMatch, (Object)replacement));
        LqnXmlHandler.replaceInXMLFile(filename, stringsToReplace);
    }

    private static void writeContentToFile(String filename, String content) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String readContentFromFile(String filename) {
        FileInputStream fis = null;
        byte[] b = null;
        try {
            fis = new FileInputStream(filename);
            int x = 0;
            x = fis.available();
            b = new byte[x];
            fis.read(b);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String content = new String(b);
        return content;
    }
}

