/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.ImplementationComponentType;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.transformations.pcm2lqn.CallType;

public class Pcm2LqnHelper {
    static HashMap<String, Integer> guidMap = new HashMap();
    static int guidCounter = 0;
    static boolean shortenIds = false;

    public static String fixGUID(String id) {
        return id.replaceAll("-", "x");
    }

    public static String getId(Identifier object, ContextWrapper cw) {
        String className = Pcm2LqnHelper.getClassName(object);
        String id = "";
        if (object instanceof ResourceDemandingSEFF) {
            ResourceDemandingSEFF rdseff = (ResourceDemandingSEFF)object;
            ImplementationComponentType ict = (ImplementationComponentType)rdseff.eContainer();
            String compName = ict.getEntityName();
            String ifName = ((OperationSignature)rdseff.getDescribedService__SEFF()).getInterface__OperationSignature().getEntityName();
            String serviceName = rdseff.getDescribedService__SEFF().getEntityName();
            id = String.valueOf(compName) + "_" + ifName + "_" + serviceName + "_" + Pcm2LqnHelper.getAssCtxtAllocCtxtIdString(cw) + Pcm2LqnHelper.getNumberForId((Identifier)cw.getCompUsgCtx());
        } else if (object instanceof AbstractAction) {
            AbstractAction aa = (AbstractAction)object;
            String actionName = aa.getEntityName();
            id = String.valueOf(className) + "_" + actionName + "_" + aa.getId() + "_" + Pcm2LqnHelper.getAssCtxtAllocCtxtIdString(cw) + "_" + Pcm2LqnHelper.getNumberForId((Identifier)cw.getCompUsgCtx());
        } else {
            id = object instanceof Loop ? "UsageScenario_" + className + "_" + Pcm2LqnHelper.getNumberForId(object) : (object instanceof PassiveResource ? "PassiveResource_" + ((PassiveResource)object).getEntityName() + "_" + Pcm2LqnHelper.getAssCtxtAllocCtxtIdString(cw) + "_" + Pcm2LqnHelper.getNumberForId(object) : (object instanceof AcquireAction ? "AcquireAction_" + ((AcquireAction)object).getEntityName() + "_" + Pcm2LqnHelper.getAssCtxtAllocCtxtIdString(cw) + "_" + Pcm2LqnHelper.getNumberForId(object) : (object instanceof ReleaseAction ? "ReleaseAction_" + ((ReleaseAction)object).getEntityName() + "_" + Pcm2LqnHelper.getAssCtxtAllocCtxtIdString(cw) + "_" + Pcm2LqnHelper.getNumberForId(object) : String.valueOf(className) + Pcm2LqnHelper.getNumberForId(object))));
        }
        return Pcm2LqnHelper.shortenID(id);
    }

    private static String shortenID(String id) {
        if (shortenIds && id.length() > 50) {
            return id.substring(id.length() - 50, id.length());
        }
        return id;
    }

    private static String getClassName(Identifier object) {
        return object.getClass().getSimpleName().replaceAll("Impl", "");
    }

    private static String getAssCtxtAllocCtxtIdString(ContextWrapper cw) {
        String assCtxtAllocCtxtName = "";
        List assCtxList = cw.getAssCtxList();
        for (AssemblyContext ac : assCtxList) {
            assCtxtAllocCtxtName = String.valueOf(assCtxtAllocCtxtName) + Pcm2LqnHelper.getNumberForId((Identifier)ac);
        }
        assCtxtAllocCtxtName = String.valueOf(assCtxtAllocCtxtName) + Pcm2LqnHelper.getNumberForId((Identifier)cw.getAllCtx());
        return Pcm2LqnHelper.shortenID(assCtxtAllocCtxtName);
    }

    private static int getNumberForId(Identifier object) {
        Integer value = guidMap.get(object.getId());
        if (value == null) {
            guidMap.put(object.getId(), ++guidCounter);
            return guidCounter;
        }
        return value;
    }

    public static void clearGuidMap() {
        guidMap = new HashMap();
        guidCounter = 0;
    }

    public static String getIdForUsageScenario(UsageScenario us) {
        return Pcm2LqnHelper.shortenID("UsageScenario_" + us.getEntityName() + "_" + Pcm2LqnHelper.getNumberForId((Identifier)us));
    }

    public static String getIdForCommResource(LinkingResource lr, CommunicationLinkResourceType clrt) {
        String clrtString = clrt == null ? "none" : clrt.getEntityName();
        return Pcm2LqnHelper.shortenID("LinkingResource_" + lr.getEntityName() + "_" + clrtString);
    }

    public static String getIdForThroughput(String commResourceID) {
        return Pcm2LqnHelper.shortenID("throughput_" + commResourceID);
    }

    public static String getIdForLatency(String commResourceID, CallType callType) {
        return Pcm2LqnHelper.shortenID("latency_" + commResourceID + "_" + (Object)((Object)callType));
    }

    public static String getIdForProcResource(Entity rc, ProcessingResourceType prt) {
        return Pcm2LqnHelper.shortenID(String.valueOf(rc.getEntityName()) + "_" + prt.getEntityName());
    }

    public static String getIdForPassiveResource(PassiveResource passiveResource, AllocationContext assCtx) {
        return Pcm2LqnHelper.shortenID(String.valueOf(Pcm2LqnHelper.getClassName((Identifier)passiveResource)) + "_" + passiveResource.getEntityName() + "_" + assCtx.getId());
    }

    public static String getIdForEntryLevelSystemCall(EntryLevelSystemCall call) {
        String className = Pcm2LqnHelper.getClassName((Identifier)call);
        String id = String.valueOf(className) + call.getId();
        return Pcm2LqnHelper.shortenID(id);
    }

    public static String getSignalEntryId(String id) {
        return Pcm2LqnHelper.shortenID(String.valueOf(id) + "Signal_Entry");
    }

    public static String getWaitEntryId(String id) {
        return Pcm2LqnHelper.shortenID(String.valueOf(id) + "Wait_Entry");
    }

    public static String getIdForForkedBehaviour(ForkedBehaviour asyncBeh, ContextWrapper myContextWrapper) {
        StartAction startAction = (StartAction)EMFQueryHelper.getObjectByType((EList)asyncBeh.getSteps_Behaviour(), StartAction.class);
        return Pcm2LqnHelper.shortenID("ForkedBehaviour_" + Pcm2LqnHelper.getNumberForId((Identifier)startAction));
    }
}

