/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.probfunction.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.ProbabilityFunction;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionSolveVisitor;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.stoex.api.StoExSerialiser;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;
import org.palladiosimulator.solver.core.utils.ManagedPMFParser;
import org.palladiosimulator.solver.core.utils.StringNotPMFException;
import org.palladiosimulator.solver.core.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.core.visitors.ExpressionHelper;
import org.palladiosimulator.solver.lqn.ActivityDefType;
import org.palladiosimulator.solver.lqn.ActivityMakingCallType;
import org.palladiosimulator.solver.lqn.ActivityPhasesType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.PhaseActivities;
import org.palladiosimulator.solver.lqn.PrecedenceType;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.SchedulingType;
import org.palladiosimulator.solver.lqn.TaskSchedulingType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.lqn.TypeType;
import org.palladiosimulator.solver.transformations.pcm2lqn.CallType;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnBuilder;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;
import org.palladiosimulator.solver.transformations.pcm2lqn.Rdseff2Lqn;

public class UsageModel2Lqn
extends UsagemodelSwitch<String> {
    private static final String USAGE_DELAY = "USAGE_DELAY";
    private static final Logger LOGGER = Logger.getLogger((String)UsageModel2Lqn.class.getName());
    private static final StoExSerialiser STOEX_SERIALISER = StoExSerialiser.createInstance();
    private int counter;
    private ContextWrapper myContextWrapper;
    private LqnBuilder lqnBuilder;

    public UsageModel2Lqn(LqnBuilder aLqnBuilder, ContextWrapper ctxWrp) {
        this.lqnBuilder = aLqnBuilder;
        this.myContextWrapper = ctxWrp;
        this.counter = 0;
    }

    public String caseUsageModel(UsageModel usageModel) {
        ProcessorType pt = this.lqnBuilder.addProcessor(USAGE_DELAY);
        pt.setScheduling(SchedulingType.INF);
        TaskType tt = this.lqnBuilder.addTask(USAGE_DELAY, pt);
        EntryType et = this.lqnBuilder.addEntry(USAGE_DELAY + this.counter, tt);
        et.setType(TypeType.PH1PH2);
        ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(USAGE_DELAY + this.counter);
        apt.setHostDemandMean((Object)"0.0");
        PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
        et.setEntryPhaseActivities(pa);
        ++this.counter;
        EList scenList = usageModel.getUsageScenario_UsageModel();
        for (UsageScenario us : scenList) {
            this.doSwitch((EObject)us);
        }
        return null;
    }

    public String caseUsageScenario(UsageScenario object) {
        this.doSwitch((EObject)object.getWorkload_UsageScenario());
        this.doSwitch((EObject)object.getScenarioBehaviour_UsageScenario());
        return null;
    }

    public String caseClosedWorkload(ClosedWorkload closedWorkload) {
        UsageScenario us = (UsageScenario)closedWorkload.eContainer();
        String id = Pcm2LqnHelper.getIdForUsageScenario(us);
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        String population = new Integer(closedWorkload.getPopulation()).toString();
        PCMRandomVariable thinkTime = closedWorkload.getThinkTime_ClosedWorkload();
        if (thinkTime == null) {
            throw new RuntimeException("No think time defined for closed workload. Fix your model and validate it before running the analyses.");
        }
        tt.setMultiplicity((Object)new BigInteger(population));
        String specification = thinkTime.getSpecification();
        double thinkTimeValue = this.getDoubleMeanValueFromSpecification(thinkTime.getSpecification());
        tt.setThinkTime((Object)thinkTimeValue);
        tt.setScheduling(TaskSchedulingType.REF);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        this.lqnBuilder.addOutputEntryDistributionType(et);
        this.lqnBuilder.addTaskActivityGraph(tt);
        return null;
    }

    public String caseOpenWorkload(OpenWorkload openWorkload) {
        UsageScenario us = (UsageScenario)openWorkload.eContainer();
        String id = Pcm2LqnHelper.getIdForUsageScenario(us);
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        ExpressionInferTypeVisitor visitor = new ExpressionInferTypeVisitor();
        String specification = openWorkload.getInterArrivalTime_OpenWorkload().getSpecification();
        double interarrivaltime = this.getDoubleMeanValueFromSpecification(specification);
        String arrivalRate = String.valueOf(1.0 / interarrivaltime);
        et.setOpenArrivalRate((Object)arrivalRate);
        this.lqnBuilder.addTaskActivityGraph(tt);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getDoubleMeanValueFromSpecification(String specification) {
        double result = 0.0;
        Expression exp = ExpressionHelper.parseToExpression((String)specification);
        if (IntLiteral.class.isInstance(exp)) {
            IntLiteral intExp = (IntLiteral)exp;
            return intExp.getValue();
        }
        if (DoubleLiteral.class.isInstance(exp)) {
            DoubleLiteral doubleExp = (DoubleLiteral)exp;
            return doubleExp.getValue();
        }
        if (!FunctionLiteral.class.isInstance(exp)) throw new RuntimeException("Only double values, integer values or exponential functions are supported as interarrival or think time time. You provided something else: " + specification);
        ExpressionSolveVisitor expressionSolveVisitor = new ExpressionSolveVisitor(ExpressionHelper.getTypeAnnotation((Expression)exp), arg_0 -> ((StoExSerialiser)STOEX_SERIALISER).serialise(arg_0));
        Expression resultExpression = (Expression)expressionSolveVisitor.doSwitch((EObject)exp);
        if (!ProbabilityFunctionLiteral.class.isInstance(resultExpression)) throw new RuntimeException("Only double values, integer values or exponential functions are supported as interarrival or think time time. You provided something else: " + specification);
        ProbabilityFunctionLiteral propFunctionLiteral = (ProbabilityFunctionLiteral)resultExpression;
        ProbabilityFunction probFunc = propFunctionLiteral.getFunction_ProbabilityFunctionLiteral();
        if (!(probFunc instanceof ExponentialDistribution)) return result;
        ExponentialDistribution expDistr = (ExponentialDistribution)probFunc;
        return 1.0 / expDistr.getRate();
    }

    public String caseScenarioBehaviour(ScenarioBehaviour object) {
        return (String)this.doSwitch((EObject)this.getStartAction(object));
    }

    public String caseStart(Start object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        String entryId = "";
        if (object.eContainer().eContainer() instanceof UsageScenario) {
            UsageScenario us = (UsageScenario)object.eContainer().eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getIdForUsageScenario(us)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else if (object.eContainer().eContainer() instanceof Loop) {
            Loop loop = (Loop)object.eContainer().eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getId((Identifier)loop, this.myContextWrapper)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else {
            this.lqnBuilder.addActivityDef(id);
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
        if (entryId.equals("")) {
            return id;
        }
        return entryId;
    }

    public String caseStop(Stop object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.lqnBuilder.addActivityDef(id);
        return id;
    }

    public String caseEntryLevelSystemCall(EntryLevelSystemCall object) {
        String id = Pcm2LqnHelper.getIdForEntryLevelSystemCall(object);
        List contextWrapperList = this.myContextWrapper.getContextWrapperFor(object);
        double branchProb = 1.0 / (double)contextWrapperList.size();
        Iterator iterator = contextWrapperList.iterator();
        while (iterator.hasNext()) {
            ContextWrapper contextWrapperForComponentInstance;
            this.myContextWrapper = contextWrapperForComponentInstance = (ContextWrapper)iterator.next();
            this.createCallActivity(object, id, contextWrapperForComponentInstance, branchProb);
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
        return id;
    }

    private void createCallActivity(EntryLevelSystemCall object, String id, ContextWrapper contextWrapperForComponentInstance, double callMeans) {
        RepositoryComponent offeringComponent = contextWrapperForComponentInstance.getAssCtx().getEncapsulatedComponent__AssemblyContext();
        String entryId = "";
        if (offeringComponent instanceof BasicComponent) {
            ServiceEffectSpecification seff = contextWrapperForComponentInstance.getNextSEFF(object);
            Rdseff2Lqn seffVisitor = new Rdseff2Lqn(this.lqnBuilder, contextWrapperForComponentInstance);
            try {
                entryId = (String)seffVisitor.doSwitch((EObject)((ResourceDemandingSEFF)seff));
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"Error while visiting RDSEFF");
                throw e;
            }
        } else {
            LOGGER.error((Object)"Composite Component type not yet supported.");
            throw new UnsupportedOperationException();
        }
        this.lqnBuilder.addActivityDef(id);
        this.lqnBuilder.addActivityMakingCall(id, entryId, CallType.SYNCH, callMeans);
    }

    public String caseDelay(Delay object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        ProcessorType delayProcessor = this.lqnBuilder.getProcessor(USAGE_DELAY);
        TaskType delayTask = (TaskType)delayProcessor.getTask().get(0);
        EntryType et = this.lqnBuilder.addEntry(USAGE_DELAY + this.counter, delayTask);
        et.setType(TypeType.PH1PH2);
        ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(USAGE_DELAY + this.counter);
        ++this.counter;
        String hostDemand = object.getTimeSpecification_Delay().getSpecification();
        apt.setHostDemandMean((Object)this.getDoubleMeanValueFromSpecification(hostDemand));
        PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
        et.setEntryPhaseActivities(pa);
        this.lqnBuilder.addActivityDef(id);
        this.lqnBuilder.addActivityMakingCall(id, et.getName(), CallType.SYNCH);
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
        return id;
    }

    public String caseBranch(Branch object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.lqnBuilder.addActivityDef(id);
        PrecedenceType ptBegin = this.lqnBuilder.addBeginBranchPrecedence(id);
        PrecedenceType ptEnd = this.lqnBuilder.addEndBranchPrecedence();
        EList btList = object.getBranchTransitions_Branch();
        for (BranchTransition bt : btList) {
            ScenarioBehaviour sb = bt.getBranchedBehaviour_BranchTransition();
            String startId = (String)this.doSwitch((EObject)sb);
            String branchProb = new Double(bt.getBranchProbability()).toString();
            this.lqnBuilder.addActivityOrType(startId, branchProb, ptBegin);
            String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction(sb), this.myContextWrapper);
            this.lqnBuilder.addActivityType(stopId, ptEnd);
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor());
        ptEnd.getPost().getActivity().setName(successorId);
        return id;
    }

    public String caseLoop(Loop object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        String startId = this.handleLoopBody(object, id);
        this.lqnBuilder.addActivityDef(id);
        ActivityMakingCallType amct = this.lqnBuilder.addActivityMakingCall(id, startId, CallType.SYNCH);
        amct.setCallsMean((Object)this.getLoopIterations(object));
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
        return id;
    }

    private String handleLoopBody(Loop loop, String id) {
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        this.lqnBuilder.addTaskActivityGraph(tt);
        ScenarioBehaviour sb = loop.getBodyBehaviour_Loop();
        String startId = (String)this.doSwitch((EObject)this.getStartAction(sb));
        String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction(sb), this.myContextWrapper);
        this.lqnBuilder.addReplyActivity(id, startId, stopId);
        this.lqnBuilder.restoreFormerTaskActivityGraph();
        return startId;
    }

    private String getLoopIterations(Loop object) {
        ManagedPMF pmf = null;
        try {
            pmf = ManagedPMFParser.createFromString((String)object.getLoopIteration_Loop().getSpecification());
        }
        catch (StringNotPMFException e) {
            e.printStackTrace();
        }
        if (pmf != null) {
            try {
                return String.valueOf(pmf.getPmfTimeDomain().getArithmeticMeanValue());
            }
            catch (DomainNotNumbersException e) {
                return "0.0";
            }
            catch (FunctionNotInTimeDomainException e) {
                return "0.0";
            }
        }
        return "0.0";
    }

    private Stop getStopAction(ScenarioBehaviour object) {
        Stop stopAction = (Stop)EMFQueryHelper.getObjectByType((EList)object.getActions_ScenarioBehaviour(), Stop.class);
        return stopAction;
    }

    private Start getStartAction(ScenarioBehaviour object) {
        Start startAction = (Start)EMFQueryHelper.getObjectByType((EList)object.getActions_ScenarioBehaviour(), Start.class);
        return startAction;
    }
}

