/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visualisation;

import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;

public class JFVisualisation {
    protected JFrame graphFrame;
    protected JFreeChart myChart;
    protected ChartPanel chartPanel;
    protected DefaultTableXYDataset dataset = new DefaultTableXYDataset();
    protected double distance;

    public JFVisualisation(double distance) {
        this.graphFrame = new JFrame("Execution Time");
        this.distance = distance;
    }

    public void addSamplePDF(ISamplePDF samplePDF, String name) throws ProbabilityFunctionException {
        XYSeries series = new XYSeries((Comparable)((Object)name), true, false);
        samplePDF = samplePDF.getFunctionWithNewDistance(this.distance);
        List points = samplePDF.getValuesAsDouble();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("test.csv"));
            int i = 0;
            for (Double point : points) {
                series.add((double)i, (Number)point);
                out.write(String.valueOf((double)i / 10.0) + ";" + point);
                out.newLine();
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dataset.addSeries(series);
    }

    public void visualize() {
        this.dataset.setIntervalWidth(this.distance);
        this.myChart = ChartFactory.createHistogram((String)"Measured Execution Time Histogram", (String)("Time [" + this.distance + " s]"), (String)"Probability", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.myChart.getPlot();
        plot.getRangeAxis().setRange(0.0, 1.1);
        this.graphFrame.setSize(800, 600);
        this.graphFrame.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.graphFrame.getSize().width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.graphFrame.getSize().height) / 2);
        this.graphFrame.getContentPane().setLayout(new BorderLayout());
        this.chartPanel = new ChartPanel(this.myChart);
        this.graphFrame.getContentPane().add((Component)this.chartPanel, "Center");
        this.graphFrame.setVisible(true);
    }

    public void visualizeOverlay() {
        this.dataset.setIntervalWidth(1.0);
        this.myChart = ChartFactory.createHistogram((String)"", (String)("Time [" + this.distance + " ms]"), (String)"Probability", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.myChart.getPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.BLUE.brighter());
        plot.getRenderer().setSeriesPaint(1, (Paint)Color.BLUE.brighter());
        plot.setForegroundAlpha(0.8f);
        plot.getRangeAxis().setAutoRange(true);
        plot.setBackgroundPaint((Paint)Color.white);
        this.graphFrame.setSize(800, 600);
        this.graphFrame.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.graphFrame.getSize().width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.graphFrame.getSize().height) / 2);
        this.graphFrame.getContentPane().setLayout(new BorderLayout());
        this.chartPanel = new ChartPanel(this.myChart);
        this.graphFrame.getContentPane().add((Component)this.chartPanel, "Center");
        this.graphFrame.setVisible(true);
    }

    public void addPMF(ManagedPMF managedPMF, String name) {
        IProbabilityMassFunction pmf = managedPMF.getPmfTimeDomain();
        XYSeries series = new XYSeries((Comparable)((Object)name), true, false);
        List points = pmf.getSamples();
        for (ISample sample : points) {
            double value = ((Integer)sample.getValue()).intValue();
            series.add(value, sample.getProbability());
        }
        this.dataset.addSeries(series);
    }
}

