/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.view.plantuml.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.impl.AssemblyConnectorImpl;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.view.plantuml.generator.UmlDiagramSupplier;

public class PcmAllocationDiagramGenerator
implements UmlDiagramSupplier {
    private static final String COMPONENT_KEYWORD = "component";
    private static final String COMPONENT_START = "[";
    private static final String COMPONENT_END = "]";
    private static final String CONTAINER_KEYWORD = "node";
    private static final String CURLY_OPENING_BRACKET = "{";
    private static final String CURLY_CLOSING_BRACKET = "}";
    private static final String LINK_START = "[[";
    private static final String LINK_END = "]]";
    private static final String NEWLINE = "\n";
    private static final String PROVIDES_REQUIRES_LINK = " - ";
    private static final String SPACE = " ";
    private final Map<RepositoryComponent, RepositoryComponent> assembly;
    private final List<BasicComponent> basicComponents;
    private final StringBuilder buffer = new StringBuilder();
    private final List<CompositeComponent> compositeComponents;
    private final String diagramText;
    private final String linkToSystem;

    public PcmAllocationDiagramGenerator(Allocation allocation) {
        List<AllocationContext> contexts = allocation.getAllocationContexts_Allocation().stream().filter(context -> context != null).filter(context -> context.getResourceContainer_AllocationContext() != null).filter(context -> context.getAssemblyContext_AllocationContext() != null).toList();
        contexts.get(0).getAllocation_AllocationContext().getSystem_Allocation().getAssemblyContexts__ComposedStructure();
        this.assembly = new HashMap<RepositoryComponent, RepositoryComponent>();
        contexts.stream().map(AllocationContext::getAllocation_AllocationContext).filter(a -> a != null).map(Allocation::getSystem_Allocation).filter(s -> s != null).distinct().map(ComposedStructure::getConnectors__ComposedStructure).filter(c -> c != null).flatMap(Collection::stream).filter(c -> c != null).distinct().filter(AssemblyConnectorImpl.class::isInstance).map(AssemblyConnectorImpl.class::cast).distinct().sorted(UmlDiagramSupplier.byName()).forEachOrdered(c -> {
            AssemblyContext providingAssembly = c.getProvidingAssemblyContext_AssemblyConnector();
            AssemblyContext requiringAssembly = c.getRequiringAssemblyContext_AssemblyConnector();
            if (providingAssembly != null && requiringAssembly != null) {
                RepositoryComponent providingComponent = providingAssembly.getEncapsulatedComponent__AssemblyContext();
                RepositoryComponent requiringComponent = requiringAssembly.getEncapsulatedComponent__AssemblyContext();
                if (providingComponent != null && requiringComponent != null) {
                    this.assembly.put(providingComponent, requiringComponent);
                }
            }
        });
        this.assembly.keySet().stream().forEach(k -> System.out.println(String.valueOf(UmlDiagramSupplier.escape(k.getEntityName())) + " : " + UmlDiagramSupplier.escape(this.assembly.get(k).getEntityName())));
        List<RepositoryComponent> components = contexts.stream().map(AllocationContext::getAssemblyContext_AllocationContext).map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).toList();
        this.basicComponents = components.stream().filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).distinct().sorted(UmlDiagramSupplier.byName()).collect(Collectors.toCollection(ArrayList::new));
        this.compositeComponents = components.stream().filter(CompositeComponent.class::isInstance).map(CompositeComponent.class::cast).distinct().sorted(UmlDiagramSupplier.byName()).toList();
        this.linkToSystem = UmlDiagramSupplier.getEObjectHyperlink((EObject)allocation.getSystem_Allocation());
        this.diagramText = contexts.isEmpty() ? "" : this.getAllocationDiagramText();
    }

    private void appendAssemblyConnector(Map.Entry<String, String> assembly) {
        this.buffer.append(COMPONENT_START);
        this.buffer.append(assembly.getKey());
        this.buffer.append(COMPONENT_END);
        this.buffer.append(PROVIDES_REQUIRES_LINK);
        this.buffer.append(COMPONENT_START);
        this.buffer.append(assembly.getValue());
        this.buffer.append(COMPONENT_END);
        this.buffer.append(NEWLINE);
    }

    private void appendComponent(BasicComponent component) {
        this.buffer.append(COMPONENT_START);
        this.buffer.append(UmlDiagramSupplier.escape(component.getEntityName()));
        this.buffer.append(COMPONENT_END);
        this.buffer.append(SPACE);
        this.buffer.append(LINK_START);
        this.buffer.append(this.linkToSystem);
        this.buffer.append(LINK_END);
        this.buffer.append(NEWLINE);
    }

    private void appendComponentStart(CompositeComponent component) {
        this.buffer.append(COMPONENT_KEYWORD);
        this.buffer.append(SPACE);
        this.buffer.append(UmlDiagramSupplier.escape(component.getEntityName()));
        this.buffer.append(SPACE);
        this.buffer.append(CURLY_OPENING_BRACKET);
        this.buffer.append(NEWLINE);
    }

    private void appendContainerStart(String containerName) {
        this.buffer.append(CONTAINER_KEYWORD);
        this.buffer.append(SPACE);
        this.buffer.append(UmlDiagramSupplier.escape(containerName));
        this.buffer.append(SPACE);
        this.buffer.append(CURLY_OPENING_BRACKET);
        this.buffer.append(NEWLINE);
    }

    private void appendEnd() {
        this.buffer.append(CURLY_CLOSING_BRACKET);
        this.buffer.append(NEWLINE);
    }

    private boolean contains(CompositeComponent composite, BasicComponent basic) {
        return composite.getAssemblyContexts__ComposedStructure().stream().map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).anyMatch(c -> Objects.equals(c, basic));
    }

    @Override
    public String get() {
        return this.diagramText;
    }

    private String getAllocationDiagramText() {
        String container;
        this.buffer.append("skinparam fixCircleLabelOverlapping true");
        this.buffer.append(NEWLINE);
        this.buffer.append("skinparam componentStyle uml2");
        this.buffer.append(NEWLINE);
        HashMap<BasicComponent, String> map = new HashMap<BasicComponent, String>();
        for (CompositeComponent composite : this.compositeComponents) {
            container = this.getContainerName((NamedElement)composite);
            this.appendContainerStart(container);
            this.appendComponentStart(composite);
            ArrayList<BasicComponent> done = new ArrayList<BasicComponent>();
            for (BasicComponent basic : this.basicComponents) {
                if (!this.contains(composite, basic)) continue;
                this.appendComponent(basic);
                map.put(basic, container);
                done.add(basic);
            }
            this.basicComponents.removeAll(done);
            this.appendEnd();
            this.appendEnd();
        }
        for (BasicComponent component : this.basicComponents) {
            container = this.getContainerName((NamedElement)component);
            this.appendContainerStart(container);
            this.appendComponent(component);
            map.put(component, container);
            this.appendEnd();
        }
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        for (RepositoryComponent component : this.assembly.keySet()) {
            String from = (String)map.get(component);
            String to = (String)map.get(this.assembly.get(component));
            if (from == null || to == null || from.equals(to)) continue;
            set.add(Map.entry(from, to));
        }
        set.stream().distinct().sorted((o1, o2) -> (String.valueOf((String)o1.getKey()) + (String)o1.getValue()).compareTo(String.valueOf((String)o2.getKey()) + (String)o2.getValue())).forEachOrdered(this::appendAssemblyConnector);
        return this.buffer.toString();
    }

    private String getContainerName(NamedElement entity) {
        return CONTAINER_KEYWORD + UmlDiagramSupplier.escape(entity.getEntityName());
    }
}

