/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.view.plantuml.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.view.plantuml.generator.UmlDiagramSupplier;

public class PcmComponentDiagramGenerator
implements UmlDiagramSupplier {
    private static final String COMPONENT_START = "[";
    private static final String COMPONENT_END = "]";
    private static final String COMPOSITE_BLOCK_END = "}";
    private static final String COMPOSITE_BLOCK_START = "\" {";
    private static final String COMPOSITE_COMPONENT_START = "component \"";
    private static final String COMPOSITE_TITLE_SPACER = "\\n\\n\\n\\n\\n\\n";
    private static final String INPORT_DECLARATION = "portin \" \" as ";
    private static final String INPORT_DELIMITER = ".requires.";
    private static final String NAME_START = "\"";
    private static final String NAME_END = "\"";
    private static final String NEWLINE = "\n";
    private static final String OUTPORT_DECLARATION = "portout \" \" as ";
    private static final String OUTPORT_DELIMITER = ".provides.";
    private static final String REQUIRES_LABEL = " : requires";
    private static final String SIMPLE_LINK = "--";
    private static final String REQUIRES_LINK = "..>";
    private static final String INTERNAL_REQUIRES_LINK = "..";
    private final List<BasicComponent> basicComponents = new ArrayList<BasicComponent>();
    private final Set<String> componentNames = new HashSet<String>();
    private final List<CompositeComponent> compositeComponents = new ArrayList<CompositeComponent>();
    private final String diagramText;
    private final List<OperationInterface> ifaces = new ArrayList<OperationInterface>();
    private final Set<RepositoryComponent> innerComponents = new HashSet<RepositoryComponent>();
    private final Map<CompositeComponent, Map<Role, String>> inPorts = new HashMap<CompositeComponent, Map<Role, String>>();
    private final Map<CompositeComponent, Map<Role, String>> outPorts = new HashMap<CompositeComponent, Map<Role, String>>();
    private final Map<RepositoryComponent, EList<ProvidedRole>> providedRoles = new HashMap<RepositoryComponent, EList<ProvidedRole>>();
    private final Map<RepositoryComponent, EList<RequiredRole>> requiredRoles = new HashMap<RepositoryComponent, EList<RequiredRole>>();

    private static void appendComponent(BasicComponent component, StringBuilder buffer) {
        buffer.append(COMPONENT_START);
        buffer.append(UmlDiagramSupplier.escape(component.getEntityName()));
        buffer.append(COMPONENT_END);
    }

    private static void appendConnector(AssemblyConnector connector, StringBuilder buffer) {
        AssemblyContext requiringContext = connector.getRequiringAssemblyContext_AssemblyConnector();
        AssemblyContext providingContext = connector.getProvidingAssemblyContext_AssemblyConnector();
        PcmComponentDiagramGenerator.appendComponent((BasicComponent)requiringContext.getEncapsulatedComponent__AssemblyContext(), buffer);
        buffer.append(REQUIRES_LINK);
        PcmComponentDiagramGenerator.appendComponent((BasicComponent)providingContext.getEncapsulatedComponent__AssemblyContext(), buffer);
        buffer.append(REQUIRES_LABEL);
        buffer.append(NEWLINE);
    }

    public PcmComponentDiagramGenerator(Repository repository) {
        this.diagramText = this.generateDiagramText(Objects.requireNonNull(repository));
    }

    private void addInnerComponents(CompositeComponent component) {
        for (AssemblyContext assemblyContext : component.getAssemblyContexts__ComposedStructure()) {
            RepositoryComponent innerComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
            Set connectedProvisions = component.getConnectors__ComposedStructure().stream().filter(AssemblyConnector.class::isInstance).map(AssemblyConnector.class::cast).map(AssemblyConnector::getProvidedRole_AssemblyConnector).sorted((a, b) -> UmlDiagramSupplier.escape(a.getProvidedInterface__OperationProvidedRole().getEntityName()).compareTo(UmlDiagramSupplier.escape(b.getProvidedInterface__OperationProvidedRole().getEntityName()))).collect(Collectors.toSet());
            Set connectedRequirements = component.getConnectors__ComposedStructure().stream().filter(AssemblyConnector.class::isInstance).map(AssemblyConnector.class::cast).map(AssemblyConnector::getRequiredRole_AssemblyConnector).sorted((a, b) -> UmlDiagramSupplier.escape(a.getRequiredInterface__OperationRequiredRole().getEntityName()).compareTo(UmlDiagramSupplier.escape(b.getRequiredInterface__OperationRequiredRole().getEntityName()))).collect(Collectors.toSet());
            EList innerProvisions = innerComponent.getProvidedRoles_InterfaceProvidingEntity();
            innerProvisions.removeAll(connectedProvisions);
            ECollections.sort((EList)innerProvisions, UmlDiagramSupplier.byName());
            EList innerRequirements = innerComponent.getRequiredRoles_InterfaceRequiringEntity();
            innerRequirements.removeAll(connectedRequirements);
            ECollections.sort((EList)innerRequirements, UmlDiagramSupplier.byName());
            this.providedRoles.put(innerComponent, (EList<ProvidedRole>)innerProvisions);
            this.requiredRoles.put(innerComponent, (EList<RequiredRole>)innerRequirements);
        }
    }

    private void appendComponent(CompositeComponent component, StringBuilder buffer) {
        buffer.append(COMPOSITE_COMPONENT_START);
        buffer.append(component.getEntityName());
        buffer.append(COMPOSITE_TITLE_SPACER);
        buffer.append(COMPOSITE_BLOCK_START);
        buffer.append(NEWLINE);
        component.getAssemblyContexts__ComposedStructure().stream().map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).forEach(x -> {
            PcmComponentDiagramGenerator.appendComponent(x, buffer);
            buffer.append(NEWLINE);
        });
        this.inPorts.get(component).values().forEach(x -> {
            buffer.append(INPORT_DECLARATION);
            buffer.append((String)x);
            buffer.append(NEWLINE);
        });
        this.outPorts.get(component).values().forEach(x -> {
            buffer.append(OUTPORT_DECLARATION);
            buffer.append((String)x);
            buffer.append(NEWLINE);
        });
        component.getConnectors__ComposedStructure().stream().filter(AssemblyConnector.class::isInstance).map(AssemblyConnector.class::cast).sorted(UmlDiagramSupplier.byName()).forEach(x -> PcmComponentDiagramGenerator.appendConnector(x, buffer));
        component.getConnectors__ComposedStructure().stream().filter(ProvidedDelegationConnector.class::isInstance).map(ProvidedDelegationConnector.class::cast).sorted(UmlDiagramSupplier.byName()).forEach(x -> this.appendDelegation(component, (ProvidedDelegationConnector)x, buffer));
        component.getConnectors__ComposedStructure().stream().filter(RequiredDelegationConnector.class::isInstance).map(RequiredDelegationConnector.class::cast).sorted(UmlDiagramSupplier.byName()).forEach(x -> this.appendDelegation(component, (RequiredDelegationConnector)x, buffer));
        buffer.append(COMPOSITE_BLOCK_END);
    }

    private void appendDelegation(CompositeComponent parent, ProvidedDelegationConnector delegation, StringBuilder buffer) {
        AssemblyContext providingContext = delegation.getAssemblyContext_ProvidedDelegationConnector();
        String portName = this.inPorts.get(parent).get(delegation.getOuterProvidedRole_ProvidedDelegationConnector());
        buffer.append("\"");
        buffer.append(portName);
        buffer.append("\"");
        buffer.append(SIMPLE_LINK);
        PcmComponentDiagramGenerator.appendComponent((BasicComponent)providingContext.getEncapsulatedComponent__AssemblyContext(), buffer);
        buffer.append(NEWLINE);
    }

    protected void appendDelegation(CompositeComponent parent, RequiredDelegationConnector delegation, StringBuilder buffer) {
        AssemblyContext requiringContext = delegation.getAssemblyContext_RequiredDelegationConnector();
        String portName = this.outPorts.get(parent).get(delegation.getOuterRequiredRole_RequiredDelegationConnector());
        PcmComponentDiagramGenerator.appendComponent((BasicComponent)requiringContext.getEncapsulatedComponent__AssemblyContext(), buffer);
        buffer.append(INTERNAL_REQUIRES_LINK);
        buffer.append("\"");
        buffer.append(portName);
        buffer.append("\"");
        buffer.append(NEWLINE);
    }

    private String appendIface(Role role, StringBuilder buffer) {
        String ifaceName = this.getIFaceByRef(role).getEntityName();
        String ifaceIdentifier = "interface." + UmlDiagramSupplier.escape(ifaceName);
        buffer.append("interface ");
        buffer.append("\"");
        buffer.append(ifaceName);
        buffer.append("\"");
        buffer.append(" as ");
        buffer.append(ifaceIdentifier);
        buffer.append(NEWLINE);
        return ifaceIdentifier;
    }

    private void appendProvIfaces(BasicComponent component, StringBuilder buffer) {
        for (ProvidedRole provRole : this.providedRoles.get(component)) {
            String ifaceName = UmlDiagramSupplier.escape(this.getIFaceByRef((Role)provRole).getEntityName());
            if (this.componentNames.contains(ifaceName)) continue;
            String ifaceIdentifier = this.appendIface((Role)provRole, buffer);
            buffer.append(ifaceIdentifier);
            buffer.append(SIMPLE_LINK);
            PcmComponentDiagramGenerator.appendComponent(component, buffer);
            buffer.append(NEWLINE);
        }
    }

    private void appendProvIfaces(CompositeComponent component, StringBuilder buffer) {
        for (ProvidedRole provRole : this.providedRoles.get(component)) {
            String portName = this.inPorts.get(component).get(provRole);
            String ifaceIdentifier = this.appendIface((Role)provRole, buffer);
            buffer.append(ifaceIdentifier);
            buffer.append(SIMPLE_LINK);
            buffer.append("\"");
            buffer.append(portName);
            buffer.append("\"");
            buffer.append(NEWLINE);
        }
    }

    private void appendReqIfaces(BasicComponent component, StringBuilder buffer) {
        for (RequiredRole reqRole : this.requiredRoles.get(component)) {
            String ifaceName = UmlDiagramSupplier.escape(this.getIFaceByRef((Role)reqRole).getEntityName());
            if (this.componentNames.contains(ifaceName)) {
                PcmComponentDiagramGenerator.appendComponent(component, buffer);
                buffer.append(REQUIRES_LINK);
                buffer.append(COMPONENT_START);
                buffer.append(ifaceName);
                buffer.append(COMPONENT_END);
            } else {
                String ifaceIdentifier = this.appendIface((Role)reqRole, buffer);
                PcmComponentDiagramGenerator.appendComponent(component, buffer);
                buffer.append(REQUIRES_LINK);
                buffer.append(ifaceIdentifier);
            }
            buffer.append(REQUIRES_LABEL);
            buffer.append(NEWLINE);
        }
    }

    private void appendReqIfaces(CompositeComponent component, StringBuilder buffer) {
        for (RequiredRole reqRole : this.requiredRoles.get(component)) {
            String portName = this.outPorts.get(component).get(reqRole);
            String ifaceName = UmlDiagramSupplier.escape(this.getIFaceByRef((Role)reqRole).getEntityName());
            if (this.componentNames.contains(ifaceName)) {
                buffer.append("\"");
                buffer.append(portName);
                buffer.append("\"");
                buffer.append(REQUIRES_LINK);
                buffer.append(COMPONENT_START);
                buffer.append(ifaceName);
                buffer.append(COMPONENT_END);
            } else {
                String ifaceIdentifier = this.appendIface((Role)reqRole, buffer);
                buffer.append("\"");
                buffer.append(portName);
                buffer.append("\"");
                buffer.append(REQUIRES_LINK);
                buffer.append(ifaceIdentifier);
            }
            buffer.append(REQUIRES_LABEL);
            buffer.append(NEWLINE);
        }
    }

    private void createPorts(CompositeComponent component) {
        HashMap<ProvidedRole, String> inPortNames = new HashMap<ProvidedRole, String>();
        for (ProvidedRole role : this.providedRoles.getOrDefault(component, (EList<ProvidedRole>)ECollections.asEList((Object[])new ProvidedRole[0]))) {
            if (!(role instanceof OperationProvidedRole)) continue;
            String interfaceName = ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getEntityName();
            String componentName = component.getEntityName();
            String name = String.valueOf(componentName) + INPORT_DELIMITER + interfaceName;
            inPortNames.put(role, UmlDiagramSupplier.escape(name));
        }
        this.inPorts.put(component, inPortNames);
        HashMap<RequiredRole, String> outPortNames = new HashMap<RequiredRole, String>();
        for (RequiredRole role : this.requiredRoles.getOrDefault(component, (EList<RequiredRole>)ECollections.asEList((Object[])new RequiredRole[0]))) {
            if (!(role instanceof OperationRequiredRole)) continue;
            String interfaceName = ((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getEntityName();
            String componentName = component.getEntityName();
            String name = String.valueOf(componentName) + OUTPORT_DELIMITER + interfaceName;
            outPortNames.put(role, UmlDiagramSupplier.escape(name));
        }
        this.outPorts.put(component, outPortNames);
    }

    private String generateDiagramText(Repository repository) {
        CompositeComponent comp;
        RepositoryComponent repositoryComponent;
        for (RepositoryComponent component : repository.getComponents__Repository()) {
            repositoryComponent = component;
            if (!(component instanceof CompositeComponent var4_4)) continue;
            for (AssemblyContext assemblyContext : comp.getAssemblyContexts__ComposedStructure()) {
                RepositoryComponent innerComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
                this.innerComponents.add(innerComponent);
            }
        }
        for (RepositoryComponent component : repository.getComponents__Repository()) {
            if (this.innerComponents.contains(component) || !(component instanceof BasicComponent)) continue;
            this.basicComponents.add((BasicComponent)component);
            this.providedRoles.put(component, (EList<ProvidedRole>)component.getProvidedRoles_InterfaceProvidingEntity());
            ECollections.sort(this.providedRoles.get(component), UmlDiagramSupplier.byName());
            this.requiredRoles.put(component, (EList<RequiredRole>)component.getRequiredRoles_InterfaceRequiringEntity());
            ECollections.sort(this.requiredRoles.get(component), UmlDiagramSupplier.byName());
        }
        for (RepositoryComponent component : repository.getComponents__Repository()) {
            repositoryComponent = component;
            if (!(repositoryComponent instanceof CompositeComponent) || (comp = (CompositeComponent)repositoryComponent) != (CompositeComponent)repositoryComponent) continue;
            this.compositeComponents.add(comp);
            this.addInnerComponents(comp);
            this.providedRoles.put(component, (EList<ProvidedRole>)comp.getProvidedRoles_InterfaceProvidingEntity());
            ECollections.sort(this.providedRoles.get(component), UmlDiagramSupplier.byName());
            this.requiredRoles.put(component, (EList<RequiredRole>)comp.getRequiredRoles_InterfaceRequiringEntity());
            ECollections.sort(this.requiredRoles.get(component), UmlDiagramSupplier.byName());
            this.createPorts(comp);
        }
        this.compositeComponents.sort(UmlDiagramSupplier.byName());
        this.basicComponents.sort(UmlDiagramSupplier.byName());
        this.basicComponents.forEach(x -> {
            boolean bl = this.componentNames.add(UmlDiagramSupplier.escape(x.getEntityName()));
        });
        this.compositeComponents.forEach(x -> {
            boolean bl = this.componentNames.add(UmlDiagramSupplier.escape(x.getEntityName()));
        });
        this.innerComponents.forEach(x -> {
            boolean bl = this.componentNames.add(UmlDiagramSupplier.escape(x.getEntityName()));
        });
        for (Interface iface : repository.getInterfaces__Repository()) {
            this.ifaces.add((OperationInterface)iface);
        }
        this.ifaces.sort(UmlDiagramSupplier.byName());
        if (this.compositeComponents.isEmpty() && this.basicComponents.isEmpty()) {
            return null;
        }
        return this.getComponentDiagramText();
    }

    @Override
    public String get() {
        return this.diagramText;
    }

    private String getComponentDiagramText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("skinparam fixCircleLabelOverlapping true");
        buffer.append(NEWLINE);
        buffer.append("skinparam componentStyle uml2");
        buffer.append(NEWLINE);
        for (CompositeComponent compositeComponent : this.compositeComponents) {
            this.appendComponent(compositeComponent, buffer);
            buffer.append(NEWLINE);
            this.appendProvIfaces(compositeComponent, buffer);
            this.appendReqIfaces(compositeComponent, buffer);
        }
        for (BasicComponent basicComponent : this.basicComponents) {
            boolean isNotProviding = this.providedRoles.get(basicComponent).isEmpty();
            boolean isNotRequiring = this.requiredRoles.get(basicComponent).isEmpty();
            if (isNotProviding && isNotRequiring) {
                PcmComponentDiagramGenerator.appendComponent(basicComponent, buffer);
                buffer.append(NEWLINE);
                continue;
            }
            this.appendProvIfaces(basicComponent, buffer);
            this.appendReqIfaces(basicComponent, buffer);
        }
        return buffer.toString();
    }

    private Interface getIFaceByRef(Role role) {
        EList crossRefs = role.eCrossReferences();
        for (Interface interface_ : this.ifaces) {
            if (!crossRefs.contains((Object)interface_)) continue;
            return interface_;
        }
        return null;
    }
}

