/*
 * Decompiled with CFR 0.152.
 */
package org.scaledl.usageevolution.wizard.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.scaledl.usageevolution.wizard.wizards.SelectLoadLIMBOPage;
import org.scaledl.usageevolution.wizard.wizards.SelectUsageModelPage;
import org.scaledl.usageevolution.wizard.wizards.UsageEvolutionFileGenerator;
import org.scaledl.usageevolution.wizard.wizards.UsageEvolutionSetupModel;

public class UsageEvolutionWizard
extends Wizard
implements INewWizard {
    private SelectUsageModelPage page;
    private WizardNewFileCreationPage newFilePage;
    private SelectLoadLIMBOPage loadPage;
    private IStructuredSelection selection;
    static final String FILEEXTENSION = "usageevolution";
    static final String DEFAULT_FILENAME = "default";
    private UsageEvolutionSetupModel setupModel = new UsageEvolutionSetupModel();

    public UsageEvolutionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        Object selectedElement;
        this.newFilePage = new WizardNewFileCreationPage("New usage evolution", this.selection);
        this.newFilePage.setFileExtension(FILEEXTENSION);
        this.newFilePage.setTitle("Usage Evolution Model");
        this.newFilePage.setTitle("Create Usage Evolution Model (step 1 of 3)");
        this.newFilePage.setFileName("default.usageevolution");
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFilePage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = DEFAULT_FILENAME;
                String defaultModelFilenameExtension = FILEEXTENSION;
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFilePage.setFileName(modelFilename);
            }
        }
        this.addPage((IWizardPage)this.newFilePage);
        this.page = new SelectUsageModelPage((ISelection)this.selection);
        this.page.setModel(this.setupModel);
        this.addPage((IWizardPage)this.page);
        this.loadPage = new SelectLoadLIMBOPage((ISelection)this.selection);
        this.loadPage.setModel(this.setupModel);
        this.addPage((IWizardPage)this.loadPage);
    }

    public boolean performFinish() {
        IPath path = this.newFilePage.getContainerFullPath();
        if (!path.hasTrailingSeparator()) {
            path = path.addTrailingSeparator();
        }
        String ueFileName = path + this.newFilePage.getFileName();
        this.setupModel.setUsageEvolutionFileName(ueFileName);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        UsageEvolutionWizard.this.doFinish(UsageEvolutionWizard.this.setupModel, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(UsageEvolutionSetupModel model, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + this.setupModel.usageEvolutionFileName, 2);
        final IFile file = UsageEvolutionFileGenerator.generate(this.setupModel);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (file != null && file.exists()) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException partInitException) {}
                } else {
                    MessageDialog.openError((Shell)UsageEvolutionWizard.this.getShell(), (String)"File creation error", (String)"Could not create the UsageEvolution model");
                }
            }
        });
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

