/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.EqualityChecker;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.SoMoXUtil;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SEFF2MethodMapping;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;
import tools.mdsd.jamopp.model.java.types.Type;

public class Seff2JavaASTBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(Seff2JavaASTBuilder.class);
    private final SourceCodeDecoratorRepository sourceCodeDecorator;
    private final List<SEFF2MethodMapping> seff2MethodMappings;

    public Seff2JavaASTBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
        this.sourceCodeDecorator = analysisResult.getSourceCodeDecoratorRepository();
        this.seff2MethodMappings = analysisResult.getSourceCodeDecoratorRepository().getSeff2MethodMappings();
    }

    public void addSeffsToBasicComponent(BasicComponent component, ProvidedRole providedRole) {
        if (providedRole instanceof OperationProvidedRole) {
            OperationInterface providedInterface = ((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole();
            this.addSEFFsForInterfaceToComponent(component, providedInterface, new HashSet<OperationInterface>());
        } else if (providedRole instanceof SinkRole) {
            EventGroup providedInterface = ((SinkRole)providedRole).getEventGroup__SinkRole();
            for (EventType signature : providedInterface.getEventTypes__EventGroup()) {
                this.addSeffToBasicComponent(component, (Signature)signature);
            }
        }
    }

    private void addSEFFsForInterfaceToComponent(BasicComponent component, OperationInterface providedInterface, Set<OperationInterface> alreadyAddedInterfaces) {
        if (alreadyAddedInterfaces.contains(providedInterface)) {
            return;
        }
        alreadyAddedInterfaces.add(providedInterface);
        for (OperationSignature signature : providedInterface.getSignatures__OperationInterface()) {
            this.addSeffToBasicComponent(component, (Signature)signature);
        }
        for (Interface parentIf : providedInterface.getParentInterfaces__Interface()) {
            if (!(parentIf instanceof OperationInterface)) continue;
            this.addSEFFsForInterfaceToComponent(component, (OperationInterface)parentIf, alreadyAddedInterfaces);
        }
    }

    private void addSeffToBasicComponent(BasicComponent component, Signature operation) {
        MethodLevelSourceCodeLink link = this.getMethodLevelSourceCodeLink(operation);
        if (link == null) {
            throw new RuntimeException("Found interface with operations for which no method link exists. This should never happen!");
        }
        link.setRepositoryComponent((RepositoryComponent)component);
        ResourceDemandingSEFF seff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
        "refresh".equals(link.getOperation().getEntityName());
        seff.setDescribedService__SEFF(link.getOperation());
        SEFF2MethodMapping seff2MethodMapping = SourcecodedecoratorFactory.eINSTANCE.createSEFF2MethodMapping();
        component.getServiceEffectSpecifications__BasicComponent().add((Object)seff);
        ComponentImplementingClassesLink compClassLink = this.findComponenentLink((RepositoryComponent)component);
        StatementListContainer methodBody = this.getFunctionImplementation(link.getFunction(), compClassLink, this.astModel);
        seff2MethodMapping.setStatementListContainer(methodBody);
        if (seff2MethodMapping.getStatementListContainer() == null) {
            logger.warn((Object)("Empty behaviour added for " + seff.getDescribedService__SEFF().getEntityName() + " linked method is " + seff2MethodMapping.getStatementListContainer() + "! Reverse engineering of behaviour will NOT be able to succeed for this method!"));
        }
        seff2MethodMapping.setSeff((ServiceEffectSpecification)seff);
        this.seff2MethodMappings.add(seff2MethodMapping);
    }

    private StatementListContainer getFunctionImplementationFromClassMethod(ClassMethod function, ComponentImplementingClassesLink component) {
        if (component == null) {
            logger.error((Object)"component is null");
            return null;
        }
        for (ConcreteClassifier implementingClass : component.getImplementingClasses()) {
            for (Method implementedMethod : KDMHelper.getMethods((ConcreteClassifier)implementingClass)) {
                if (!EqualityChecker.areFunctionsEqual((Method)function, (Method)implementedMethod)) continue;
                return KDMHelper.getBody((Member)implementedMethod);
            }
        }
        logger.error((Object)("No method implemementation found for method " + function.getName() + " for component " + component.getComponent().getEntityName()));
        return null;
    }

    private StatementListContainer getFunctionImplementationFromConstructor(Constructor constructor, ComponentImplementingClassesLink component) {
        for (Type implementingClass : component.getImplementingClasses()) {
            for (Constructor currentConstructor : KDMHelper.getConstructors((Type)implementingClass)) {
                if (!EqualityChecker.areConstructorsEqual((Constructor)constructor, (Constructor)currentConstructor)) continue;
                return KDMHelper.getBody((Member)currentConstructor);
            }
        }
        logger.error((Object)("No method implemementation found for method " + constructor.getName() + " for component " + component.getComponent().getEntityName()));
        return null;
    }

    private StatementListContainer getFunctionImplementation(Member member, ComponentImplementingClassesLink component, Root astModel) {
        if (member instanceof ClassMethod) {
            return this.getFunctionImplementationFromClassMethod((ClassMethod)member, component);
        }
        if (member instanceof Constructor) {
            return this.getFunctionImplementationFromConstructor((Constructor)member, component);
        }
        if (member instanceof InterfaceMethod) {
            logger.info((Object)("Found interface method " + member.getName()));
            return this.getFunctionImplementationFromInterfaceMethod((InterfaceMethod)member, component, astModel);
        }
        logger.error((Object)("No method implemementation found for member " + member.getName() + " for component " + component.getComponent().getEntityName()));
        return null;
    }

    private StatementListContainer getFunctionImplementationFromInterfaceMethod(InterfaceMethod interfaceMethod, ComponentImplementingClassesLink component, Root astModel) {
        EList implementingClasses = null;
        if (component != null) {
            implementingClasses = component.getImplementingClasses();
        }
        return this.getFunctionImplementationFromInterfaceMethod(interfaceMethod, (List<ConcreteClassifier>)implementingClasses, astModel, true);
    }

    private StatementListContainer getFunctionImplementationFromInterfaceMethod(InterfaceMethod interfaceMethod, List<ConcreteClassifier> implementingClasses, Root astModel, boolean searchInAstModelIfNotFound) {
        Collection implementingStatementListContainers = SoMoXUtil.findImplementingMethods((InterfaceMethod)interfaceMethod, implementingClasses);
        logger.info((Object)("Found " + implementingStatementListContainers.size() + " implementing StatementListContainers for interface method " + interfaceMethod.getName()));
        if (1 < implementingStatementListContainers.size()) {
            logger.info((Object)("Found more than one statement list container for interface method " + interfaceMethod.getName()));
        }
        if (implementingStatementListContainers.size() == 0) {
            if (!searchInAstModelIfNotFound) {
                logger.info((Object)("Not found any statement list container (aka. overriden method) for interface method " + interfaceMethod.getName() + " in astModel. Returning null."));
                return null;
            }
            logger.info((Object)("Not found any statement list container (aka. overriden method) for interface method " + interfaceMethod.getName() + " in component implementing classes. Looking in all classes..."));
            ArrayList<ConcreteClassifier> classifiersToLookAt = new ArrayList<ConcreteClassifier>();
            for (CompilationUnit cu : astModel.getCompilationUnits()) {
                classifiersToLookAt.addAll((Collection<ConcreteClassifier>)cu.getClassifiers());
            }
            return this.getFunctionImplementationFromInterfaceMethod(interfaceMethod, classifiersToLookAt, astModel, false);
        }
        return (StatementListContainer)implementingStatementListContainers.iterator().next();
    }

    private ComponentImplementingClassesLink findComponenentLink(RepositoryComponent component) {
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(component)) continue;
            return compLink;
        }
        logger.error((Object)("No component link found for component " + component.getEntityName()));
        return null;
    }

    private MethodLevelSourceCodeLink getMethodLevelSourceCodeLink(Signature operation) {
        assert (this.operationUnique(operation));
        for (MethodLevelSourceCodeLink link : this.sourceCodeDecorator.getMethodLevelSourceCodeLink()) {
            if (operation != link.getOperation()) continue;
            return link;
        }
        return null;
    }

    private boolean operationUnique(Signature signature) {
        boolean alreadyFound = false;
        for (MethodLevelSourceCodeLink link : this.sourceCodeDecorator.getMethodLevelSourceCodeLink()) {
            if (signature != link.getOperation()) continue;
            if (alreadyFound) {
                return false;
            }
            alreadyFound = true;
        }
        return alreadyFound;
    }
}

