/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.util.CompositionSwitch;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfacesBoundInConnectorFilter;
import org.somox.analyzer.simplemodelanalyzer.builder.util.EndpointInformation;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.PCMSystemImplementatingClassesLink;

public class InterfacePortBuilderHelper {
    private static final Logger logger = Logger.getLogger(InterfacePortBuilderHelper.class);
    private static final boolean EXHIBIT_ALL_INNER_PROVIDED_INTERFACES = true;

    public static Iterable<EndpointInformation> collectInformationOnNonBoundInterfaces(ComponentImplementingClassesLink componentLink, ComposedStructure outerComponentToCheck, boolean isProvided) {
        Iterable<EndpointInformation> interfaceLinksNotUsedInConnectors;
        Collection<EndpointInformation> allSubComponentEndpoints = InterfacePortBuilderHelper.collectComponentEndpoints(componentLink, isProvided);
        Collection<EndpointInformation> connectorEndpoints = InterfacePortBuilderHelper.collectConnectorEndpoints(outerComponentToCheck);
        if (isProvided) {
            interfaceLinksNotUsedInConnectors = allSubComponentEndpoints;
        } else {
            InterfacesBoundInConnectorFilter filter = new InterfacesBoundInConnectorFilter(connectorEndpoints);
            interfaceLinksNotUsedInConnectors = filter.filter(allSubComponentEndpoints);
        }
        return interfaceLinksNotUsedInConnectors;
    }

    private static Collection<EndpointInformation> collectConnectorEndpoints(ComposedStructure compositeComponent) {
        LinkedList<EndpointInformation> connectorEndpoints = new LinkedList<EndpointInformation>();
        CompositionSwitch<Collection<EndpointInformation>> connectorSwitch = new CompositionSwitch<Collection<EndpointInformation>>(){

            public Collection<EndpointInformation> caseProvidedDelegationConnector(ProvidedDelegationConnector object) {
                LinkedList<EndpointInformation> result = new LinkedList<EndpointInformation>();
                result.add(new EndpointInformation(null, (Role)object.getInnerProvidedRole_ProvidedDelegationConnector(), object.getAssemblyContext_ProvidedDelegationConnector()));
                return result;
            }

            public Collection<EndpointInformation> caseRequiredDelegationConnector(RequiredDelegationConnector object) {
                LinkedList<EndpointInformation> result = new LinkedList<EndpointInformation>();
                result.add(new EndpointInformation(null, (Role)object.getInnerRequiredRole_RequiredDelegationConnector(), object.getAssemblyContext_RequiredDelegationConnector()));
                return result;
            }

            public Collection<EndpointInformation> caseAssemblyConnector(AssemblyConnector object) {
                LinkedList<EndpointInformation> result = new LinkedList<EndpointInformation>();
                result.add(new EndpointInformation(null, (Role)object.getProvidedRole_AssemblyConnector(), object.getProvidingAssemblyContext_AssemblyConnector()));
                result.add(new EndpointInformation(null, (Role)object.getRequiredRole_AssemblyConnector(), object.getRequiringAssemblyContext_AssemblyConnector()));
                return result;
            }

            public Collection<EndpointInformation> defaultCase(EObject object) {
                logger.warn((Object)("Unknown connector type found when searching for bound endpoints : " + object.eClass()));
                return Collections.emptyList();
            }
        };
        for (Connector connector : compositeComponent.getConnectors__ComposedStructure()) {
            connectorEndpoints.addAll((Collection)connectorSwitch.doSwitch((EObject)connector));
        }
        return connectorEndpoints;
    }

    private static Collection<EndpointInformation> collectComponentEndpoints(ComponentImplementingClassesLink componentLink, boolean collectProvided) {
        ArrayList<EndpointInformation> allInterfaceLinks = new ArrayList<EndpointInformation>();
        for (ComponentImplementingClassesLink currentSubComponentLink : componentLink.getSubComponents()) {
            EList interfaceLinkSubList = collectProvided ? currentSubComponentLink.getProvidedInterfaces() : currentSubComponentLink.getRequiredInterfaces();
            for (InterfaceSourceCodeLink currentInterfaceLinkSub : interfaceLinkSubList) {
                AssemblyContext matchingSubComponentInstance = null;
                if (componentLink.getComponent() != null) {
                    matchingSubComponentInstance = InterfacePortBuilderHelper.getSubComponentInstance((ComposedStructure)((CompositeComponent)componentLink.getComponent()), currentSubComponentLink);
                } else if (componentLink instanceof PCMSystemImplementatingClassesLink) {
                    matchingSubComponentInstance = InterfacePortBuilderHelper.getSubComponentInstance((ComposedStructure)((PCMSystemImplementatingClassesLink)componentLink).getSystemModel(), currentSubComponentLink);
                }
                Role role = InterfacePortBuilderHelper.getInterfacePort(currentSubComponentLink, currentInterfaceLinkSub, collectProvided);
                if (role != null) {
                    allInterfaceLinks.add(new EndpointInformation(currentInterfaceLinkSub, role, matchingSubComponentInstance));
                    continue;
                }
                logger.warn((Object)("No role found for interface " + currentInterfaceLinkSub.getInterface().getEntityName() + " in Component " + currentSubComponentLink.getComponent().getEntityName()));
            }
        }
        return allInterfaceLinks;
    }

    public static Role getInterfacePort(ComponentImplementingClassesLink subComponentLink, InterfaceSourceCodeLink interfaceLinkSub, boolean searchProvidedRoles) {
        RepositoryComponent linkComponent = subComponentLink.getComponent();
        if (searchProvidedRoles) {
            EList roles = linkComponent.getProvidedRoles_InterfaceProvidingEntity();
            for (ProvidedRole currentRole : roles) {
                if (currentRole instanceof OperationProvidedRole) {
                    OperationInterface componentInterface = ((OperationProvidedRole)currentRole).getProvidedInterface__OperationProvidedRole();
                    if (!interfaceLinkSub.getInterface().equals(componentInterface)) continue;
                    return currentRole;
                }
                logger.warn((Object)("Role type not supported: " + currentRole.getClass().getSimpleName()));
            }
        } else {
            EList roles = linkComponent.getRequiredRoles_InterfaceRequiringEntity();
            for (RequiredRole currentRole : roles) {
                if (currentRole instanceof OperationRequiredRole) {
                    OperationInterface componentInterface = ((OperationRequiredRole)currentRole).getRequiredInterface__OperationRequiredRole();
                    if (!interfaceLinkSub.getInterface().equals(componentInterface)) continue;
                    return currentRole;
                }
                logger.warn((Object)("Role type not supported: " + currentRole.getClass().getSimpleName()));
            }
        }
        logger.warn((Object)"should find an interface port");
        return null;
    }

    private static AssemblyContext getSubComponentInstance(ComposedStructure outerCompositeComponent, ComponentImplementingClassesLink subComponentLink) {
        for (AssemblyContext innerAssemblyContext : outerCompositeComponent.getAssemblyContexts__ComposedStructure()) {
            if (!innerAssemblyContext.getEncapsulatedComponent__AssemblyContext().equals(subComponentLink.getComponent())) continue;
            return innerAssemblyContext;
        }
        logger.warn((Object)"no subcomponent instance found");
        return null;
    }
}

