/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;
import org.somox.kdmhelper.KDMHelper;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.types.Type;

public class ComponentInterfaceStrategy
implements IComponentInterfaceStrategy {
    private final SourceCodeDecoratorRepository sourceCodeDecorator;

    public ComponentInterfaceStrategy(SourceCodeDecoratorRepository sourceCodeDecorator) {
        this.sourceCodeDecorator = sourceCodeDecorator;
    }

    @Override
    public boolean isComponentInterface(ConcreteClassifier classToCheck) {
        return this.isRegularInterface((Type)classToCheck) || this.isPureVirtualClass(classToCheck) || this.isClassifiedAsInterfaceViaSourceCodeDecorator((Type)classToCheck);
    }

    private boolean isRegularInterface(Type classToCheck) {
        return KDMHelper.isInterface((Commentable)classToCheck);
    }

    private boolean isClassifiedAsInterfaceViaSourceCodeDecorator(Type classToCheck) {
        for (InterfaceSourceCodeLink ifLink : this.sourceCodeDecorator.getInterfaceSourceCodeLink()) {
            if (!ifLink.getGastClass().equals(classToCheck)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPureVirtualClass(ConcreteClassifier classToCheck) {
        if (KDMHelper.getMethods((ConcreteClassifier)classToCheck).size() == 0) {
            return false;
        }
        for (Method method : KDMHelper.getMethods((ConcreteClassifier)classToCheck)) {
            void classMethod;
            int size;
            ClassMethod classMethod2;
            if (!KDMHelper.isVirtual((Method)method)) {
                return false;
            }
            Method method2 = method;
            if (!(method2 instanceof ClassMethod) || (classMethod2 = (ClassMethod)method2) != (ClassMethod)method2 || (size = classMethod.getStatements().size()) <= 0) continue;
            return false;
        }
        return true;
    }
}

