/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.DataTypeSourceCodeLink;
import org.somox.sourcecodedecorator.InnerDatatypeSourceCodeLink;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;
import org.somox.util.DefaultResourceEnvironment;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.Void;
import tools.mdsd.jamopp.model.java.variables.Variable;

public class OperationBuilder
extends AbstractBuilder {
    private static final String VOID_TYPE = "void";
    private static Logger logger = Logger.getLogger(OperationBuilder.class);
    private CompositeDataType objectDataType;
    SourceCodeDecoratorRepository sourceCodeDecorator;

    public OperationBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
        this.sourceCodeDecorator = analysisResult.getSourceCodeDecoratorRepository();
    }

    public void createOperations(ConcreteClassifier implementationClass, ConcreteClassifier interfaceClass, OperationInterface interf) {
        List methods = KDMHelper.getMethods((ConcreteClassifier)interfaceClass);
        for (Method method : methods) {
            if (!method.isPublic()) continue;
            Method realMethod = method;
            if (implementationClass != null) {
                realMethod = this.getRealMethod(implementationClass, method);
                if (realMethod == null) {
                    realMethod = method;
                    logger.error((Object)("GAST Model misses a method " + method.getName()));
                }
            } else {
                logger.warn((Object)("no implementation class for method " + method.getName() + " of interface " + KDMHelper.getName((Type)interfaceClass)));
            }
            OperationSignature op = this.createOperationSignature(realMethod, interf);
            interf.getSignatures__OperationInterface().add((Object)op);
        }
    }

    private Method getRealMethod(ConcreteClassifier implementationClass, Method inputMethod) {
        assert (implementationClass != null);
        for (Method methodFromClass : KDMHelper.getMethods((ConcreteClassifier)implementationClass)) {
            if (methodFromClass == inputMethod) {
                return methodFromClass;
            }
            if (!methodFromClass.getName().equals(inputMethod.getName())) continue;
            Method overrideMethod = KDMHelper.getOverriddenASTNode((Method)methodFromClass);
            while (overrideMethod != null) {
                if (overrideMethod == inputMethod) {
                    return methodFromClass;
                }
                overrideMethod = KDMHelper.getOverriddenASTNode((Method)overrideMethod);
            }
        }
        for (ConcreteClassifier superClass : KDMHelper.getSuperTypes((ConcreteClassifier)implementationClass)) {
            Method real;
            if (KDMHelper.isAbstract((AnnotableAndModifiable)superClass) || KDMHelper.isInterface((Commentable)superClass) || !(superClass instanceof Class) || (real = this.getRealMethod(superClass, inputMethod)) == null) continue;
            return real;
        }
        return null;
    }

    private OperationSignature createOperationSignature(Method method, OperationInterface interf) {
        OperationSignature operation = RepositoryFactory.eINSTANCE.createOperationSignature();
        String nameForMethod = this.createNonExistingNameInInterface(method, interf);
        operation.setEntityName(nameForMethod);
        this.updateSourceCodeDecorator(operation, method);
        logger.info((Object)("processing input params for " + method.getName() + "; #params: " + method.getParameters().size()));
        for (Variable inputParameter : method.getParameters()) {
            Parameter opSigParam = RepositoryFactory.eINSTANCE.createParameter();
            opSigParam.setParameterName(inputParameter.getName());
            Type accessedType = GetAccessedType.getAccessedType((TypeReference)inputParameter.getTypeReference());
            if (inputParameter.getTypeReference() == null || accessedType == null) {
                logger.error((Object)("Input parameter type was null. Could not set the parameter type \"" + inputParameter.getName() + "\" of method \"" + method.getName() + "\""));
                continue;
            }
            DataType type = this.getType(accessedType, this.analysisResult.getInternalArchitectureModel(), (ArrayTypeable)inputParameter.getTypeReference());
            opSigParam.setDataType__Parameter(type);
            logger.info((Object)("type to build for variable: " + inputParameter + ":" + type));
            opSigParam.setOperationSignature__Parameter(operation);
        }
        if (method.getTypeReference() != null && GetAccessedType.getAccessedType((TypeReference)method.getTypeReference()) != null && !(method.getTypeReference() instanceof Void)) {
            DataType returnType = this.getType(GetAccessedType.getAccessedType((TypeReference)method.getTypeReference()), this.analysisResult.getInternalArchitectureModel(), (ArrayTypeable)method.getTypeReference());
            operation.setReturnType__OperationSignature(returnType);
        } else if (method.getTypeReference() != null && !(method.getTypeReference() instanceof Void)) {
            Type accessedType = GetAccessedType.getAccessedType((TypeReference)method.getTypeReference());
            DataType type = this.getType(accessedType, this.analysisResult.getInternalArchitectureModel(), (ArrayTypeable)method.getTypeReference());
            operation.setReturnType__OperationSignature(type);
        } else {
            logger.info((Object)("no fitting return type found " + method.getName() + "-- ret type" + method.getTypeReference()));
        }
        return operation;
    }

    private String createNonExistingNameInInterface(Method method, OperationInterface interf) {
        String methodName = method.getName();
        if (!this.containsName(interf, methodName)) {
            return methodName;
        }
        int counter = 1;
        while (this.containsName(interf, this.createMethodNameWithNumber(methodName, counter))) {
            ++counter;
        }
        return this.createMethodNameWithNumber(methodName, counter);
    }

    private String createMethodNameWithNumber(String methodName, int counter) {
        return String.valueOf(methodName) + "_" + counter;
    }

    private boolean containsName(OperationInterface interf, String methodName) {
        EList signatures = interf.getSignatures__OperationInterface();
        for (OperationSignature signature : signatures) {
            if (!signature.getEntityName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private void updateSourceCodeDecorator(OperationSignature operation, Method method) {
        MethodLevelSourceCodeLink link = SourcecodedecoratorFactory.eINSTANCE.createMethodLevelSourceCodeLink();
        link.setFunction((Member)method);
        link.setOperation((Signature)operation);
        if (KDMHelper.getJavaNodeSourceRegion((Commentable)method) != null) {
            link.setFile(KDMHelper.getJavaNodeSourceRegion((Commentable)method));
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
    }

    public DataType getType(Type gastType, Repository repository, ArrayTypeable arrayTypeable) {
        DataType innerType = this.getExistingType(gastType, repository);
        if (innerType == null) {
            innerType = this.createDataType(repository, gastType);
        }
        DataType returnType = innerType;
        if (arrayTypeable != null && returnType != null) {
            String unifiedListName = String.valueOf(this.getUnifiedTypeName(KDMHelper.getName((Type)gastType))) + "List";
            DataType exisingCollection = this.getExistingTypeByName(unifiedListName, repository);
            returnType = exisingCollection == null ? this.createCollectionDatatypeForArray(innerType, arrayTypeable, repository) : exisingCollection;
        }
        return returnType;
    }

    private DataType createCollectionDatatypeForArray(DataType innerDataType, ArrayTypeable arrayTypeable, Repository repository) {
        DataType currentInnerType = innerDataType;
        int arrayDimenstions = arrayTypeable.getArrayDimensionsAfter().size() + arrayTypeable.getArrayDimensionsBefore().size();
        long i = 0L;
        while (i < (long)arrayDimenstions) {
            CollectionDataType collectionDataType = RepositoryFactory.eINSTANCE.createCollectionDataType();
            collectionDataType.setEntityName(String.valueOf(this.getNameFromPCMDataType(currentInnerType)) + "List");
            collectionDataType.setInnerType_CollectionDataType(currentInnerType);
            collectionDataType.setRepository__DataType(repository);
            currentInnerType = collectionDataType;
            ++i;
        }
        return currentInnerType;
    }

    /*
     * WARNING - void declaration
     */
    private String getNameFromPCMDataType(DataType dataType) {
        void var3_2;
        PrimitiveDataType primitiveDataType;
        if (dataType instanceof NamedElement) {
            return ((NamedElement)dataType).getEntityName();
        }
        DataType dataType2 = dataType;
        if (dataType2 instanceof PrimitiveDataType && (primitiveDataType = (PrimitiveDataType)dataType2) == (PrimitiveDataType)var3_2) {
            void primitiveDataType2;
            return primitiveDataType2.getType().getName();
        }
        return null;
    }

    private DataType createDataType(Repository repository, Type gastType) {
        if (gastType == null) {
            return this.returnDefaultDataType((Commentable)gastType, repository);
        }
        String typeName = KDMHelper.getName((Type)gastType);
        if (typeName == null) {
            return this.returnDefaultDataType((Commentable)gastType, repository);
        }
        if (VOID_TYPE.equals(typeName)) {
            return null;
        }
        DataType newType = this.checkAndCreatePrimitiveDataType(typeName = this.getUnifiedTypeName(typeName));
        if (newType != null) {
            return newType;
        }
        newType = this.checkAndCreateComplexDataType(gastType, typeName, repository);
        if (newType != null) {
            return newType;
        }
        logger.warn((Object)("Datatype " + gastType + " with name " + typeName + " is neither a primitive nor a composite " + "nor a collection datatype. Creating an empty PCM datatype with name " + typeName + " for it."));
        newType = RepositoryFactory.eINSTANCE.createCompositeDataType();
        ((CompositeDataType)newType).setEntityName(typeName);
        newType.setRepository__DataType(repository);
        return newType;
    }

    private DataType checkAndCreateComplexDataType(Type gastType, String typeName, Repository repository) {
        CollectionDataType complexDataType = null;
        if (gastType instanceof ConcreteClassifier var5_6 && (complexDataType = this.checkAndCreateCollectionDataType((ConcreteClassifier)concreteClassifier, typeName, repository)) == null) {
            complexDataType = this.createCompositeDataType((ConcreteClassifier)concreteClassifier, typeName, repository);
        }
        return complexDataType;
    }

    private CompositeDataType createCompositeDataType(ConcreteClassifier concreteClassifier, String typeName, Repository repository) {
        CompositeDataType compositeDataType = RepositoryFactory.eINSTANCE.createCompositeDataType();
        compositeDataType.setEntityName(typeName);
        repository.getDataTypes__Repository().add((Object)compositeDataType);
        boolean inSource = this.isClassifierInSourceProject(concreteClassifier);
        boolean isOnBlackList = this.isClassifierOnBlacklist(concreteClassifier);
        if (inSource && !isOnBlackList) {
            DataTypeSourceCodeLink datatypeSourceCodeLink = this.createSourceCodeDecoratorEntryEntryForClassifier2DataType(concreteClassifier, (DataType)compositeDataType);
            this.investigateFields(concreteClassifier, typeName, repository, compositeDataType, datatypeSourceCodeLink);
        }
        return compositeDataType;
    }

    private void investigateFields(ConcreteClassifier concreteClassifier, String typeName, Repository repository, CompositeDataType compositeDataType, DataTypeSourceCodeLink datatypeSourceCodeLink) {
        for (Field field : concreteClassifier.getFields()) {
            Type fieldType;
            if (field.getTypeReference() == null || (fieldType = field.getTypeReference().getTarget()) == null) continue;
            String fieldTypeName = KDMHelper.getName((Type)fieldType);
            if (fieldType.equals(concreteClassifier) || fieldTypeName.equals(typeName) || VOID_TYPE.equals(fieldTypeName)) continue;
            InnerDeclaration innerElement = RepositoryFactory.eINSTANCE.createInnerDeclaration();
            DataType innerDataType = this.getType(fieldType, repository, (ArrayTypeable)field.getTypeReference());
            String innerTypeName = field.getName();
            innerElement.setEntityName(innerTypeName);
            if (innerDataType instanceof CollectionDataType) {
                CollectionDataType concreteCollectionDataType = RepositoryFactory.eINSTANCE.createCollectionDataType();
                concreteCollectionDataType.setEntityName(String.valueOf(((CollectionDataType)innerDataType).getEntityName()) + "_" + innerTypeName);
                concreteCollectionDataType.setRepository__DataType(repository);
                innerElement.setDatatype_InnerDeclaration((DataType)concreteCollectionDataType);
                QualifiedTypeArgument qta = (QualifiedTypeArgument)KDMHelper.getFirstChildWithType((Commentable)field, QualifiedTypeArgument.class);
                if (qta != null && qta.getTypeReference() != null && qta.getTypeReference().getTarget() != null) {
                    Type type = qta.getTypeReference().getTarget();
                    DataType collectionInnerType = this.getType(type, repository, (ArrayTypeable)qta);
                    concreteCollectionDataType.setInnerType_CollectionDataType(collectionInnerType);
                }
                logger.debug((Object)("created inner collection datatype composite data type " + innerTypeName));
            } else {
                innerElement.setDatatype_InnerDeclaration(innerDataType);
                logger.debug((Object)("created inner element" + innerElement.getEntityName()));
            }
            this.createSourceCodeDecoratorEntryForField2InnerDeclaration(field, innerElement, datatypeSourceCodeLink);
            compositeDataType.getInnerDeclaration_CompositeDataType().add((Object)innerElement);
        }
    }

    private boolean isClassifierOnBlacklist(ConcreteClassifier concreteClassifier) {
        if (this.somoxConfiguration == null || this.somoxConfiguration.getClassifierFilter() == null) {
            return false;
        }
        return !this.somoxConfiguration.getClassifierFilter().passes((Object)concreteClassifier);
    }

    private boolean isClassifierInSourceProject(ConcreteClassifier concreteClassifier) {
        for (CompilationUnit cu : this.astModel.getCompilationUnits()) {
            for (ConcreteClassifier currentClassifier : cu.getChildrenByType(ConcreteClassifier.class)) {
                if (concreteClassifier != currentClassifier) continue;
                return true;
            }
        }
        return false;
    }

    private void createSourceCodeDecoratorEntryForField2InnerDeclaration(Field field, InnerDeclaration innerDeclaration, DataTypeSourceCodeLink datatypeSourceCodeLink) {
        InnerDatatypeSourceCodeLink innerTypeDecorator = SourcecodedecoratorFactory.eINSTANCE.createInnerDatatypeSourceCodeLink();
        innerTypeDecorator.setField(field);
        innerTypeDecorator.setInnerDeclaration(innerDeclaration);
        datatypeSourceCodeLink.getInnerDatatypeSourceCodeLink().add((Object)innerTypeDecorator);
    }

    private DataTypeSourceCodeLink createSourceCodeDecoratorEntryEntryForClassifier2DataType(ConcreteClassifier concreteClassifier, DataType compositeDataType) {
        DataTypeSourceCodeLink dataTypeSourceCodeLink = SourcecodedecoratorFactory.eINSTANCE.createDataTypeSourceCodeLink();
        dataTypeSourceCodeLink.setFile(concreteClassifier.getContainingCompilationUnit());
        dataTypeSourceCodeLink.setJaMoPPType((Type)concreteClassifier);
        dataTypeSourceCodeLink.setPcmDataType(compositeDataType);
        this.sourceCodeDecorator.getDataTypeSourceCodeLink().add((Object)dataTypeSourceCodeLink);
        return dataTypeSourceCodeLink;
    }

    private CollectionDataType checkAndCreateCollectionDataType(ConcreteClassifier concreteClassifier, String typeName, Repository repository) {
        CollectionDataType collectionDataType = null;
        if (this.extendsJavaLangCollection((Type)concreteClassifier)) {
            collectionDataType = RepositoryFactory.eINSTANCE.createCollectionDataType();
            collectionDataType.setEntityName(concreteClassifier.getName());
            collectionDataType.setRepository__DataType(repository);
            collectionDataType.setInnerType_CollectionDataType(this.getObjectDataType(repository));
            this.createSourceCodeDecoratorEntryEntryForClassifier2DataType(concreteClassifier, (DataType)collectionDataType);
        }
        return collectionDataType;
    }

    /*
     * WARNING - void declaration
     */
    private boolean extendsJavaLangCollection(Type type) {
        void var3_2;
        ConcreteClassifier concreteClassifier;
        Type type2 = type;
        if (type2 instanceof ConcreteClassifier && (concreteClassifier = (ConcreteClassifier)type2) == (ConcreteClassifier)var3_2) {
            void concreteClassifier2;
            for (ConcreteClassifier superClassifier : concreteClassifier2.getAllSuperClassifiers()) {
                if (!"Collection".equals(superClassifier.getName()) && !"java.lang.Collection".equals(superClassifier.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private DataType checkAndCreatePrimitiveDataType(String typeName) {
        if (!VOID_TYPE.equalsIgnoreCase(typeName)) {
            if ("integer".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeInteger();
            }
            if ("double".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeDouble();
            }
            if ("string".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeString();
            }
            if ("boolean".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeBool();
            }
            if ("char".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeChar();
            }
            if ("byte".equalsIgnoreCase(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeByte();
            }
            if ("String".equals(typeName) || "java.lang.String".equals(typeName)) {
                return DefaultResourceEnvironment.getPrimitiveDataTypeString();
            }
        }
        return null;
    }

    private String getUnifiedTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        if ("int".equals(typeName.toLowerCase()) || "long".equals(typeName.toLowerCase()) || "short".equals(typeName.toLowerCase())) {
            typeName = "integer";
        } else if ("bool".equals(typeName.toLowerCase())) {
            typeName = "boolean";
        } else if ("char".equals(typeName.toLowerCase())) {
            typeName = "char";
        } else if ("float".equals(typeName.toLowerCase())) {
            typeName = "double";
        } else if ("String".equals(typeName)) {
            typeName = "STRING";
        }
        return typeName;
    }

    public DataType returnDefaultDataType(Commentable type, Repository repository) {
        logger.warn((Object)("could not determine type name for type: " + type + " returning default object datatype)"));
        return this.getObjectDataType(repository);
    }

    private DataType getObjectDataType(Repository repository) {
        if (this.objectDataType == null) {
            this.objectDataType = RepositoryFactory.eINSTANCE.createCompositeDataType();
            this.objectDataType.setEntityName("Object");
            this.objectDataType.setRepository__DataType(repository);
        }
        return this.objectDataType;
    }

    private DataType getExistingType(Type gastType, Repository repository) {
        return this.getExistingTypeByName(KDMHelper.getName((Type)gastType), repository);
    }

    private DataType getExistingTypeByName(String gastTypeName, Repository repository) {
        if (gastTypeName == null) {
            logger.warn((Object)"Type name is null. Could not get an exisiting data type.");
            return null;
        }
        gastTypeName = this.getUnifiedTypeName(gastTypeName);
        for (DataType currentType : repository.getDataTypes__Repository()) {
            String pcmTypeName = null;
            if (currentType instanceof CompositeDataType) {
                pcmTypeName = ((CompositeDataType)currentType).getEntityName();
            } else if (currentType instanceof CollectionDataType) {
                pcmTypeName = ((CollectionDataType)currentType).getEntityName();
            } else if (currentType instanceof PrimitiveDataType) {
                pcmTypeName = ((PrimitiveDataType)currentType).getType().getName();
            }
            if (!gastTypeName.equals(pcmTypeName)) continue;
            return currentType;
        }
        logger.trace((Object)("no type found for " + gastTypeName + ". Type will be created."));
        return null;
    }
}

