/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.NonDuplicatingInterfacePortBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.EndpointInformation;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.PCMSystemImplementatingClassesLink;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;
import org.somox.util.DefaultResourceEnvironment;

public class PCMSystemBuilder
extends AbstractBuilder {
    private static Logger logger = Logger.getLogger(PCMSystemBuilder.class);
    private final ComponentAndTypeNaming namingStrategy;
    private final ComponentBuilder componentBuilder;
    private final NonDuplicatingInterfacePortBuilder providedRoleBuilder;

    public PCMSystemBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult, ComponentBuilder componentBuilder) {
        super(gastModel, somoxConfiguration, analysisResult);
        logger.debug((Object)"Initialising PCM system builder");
        this.componentBuilder = componentBuilder;
        this.namingStrategy = componentBuilder.getComponentAndTypeNamingStrategy();
        this.providedRoleBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, this.namingStrategy);
    }

    public void buildSystemModel() {
        this.buildSystemModel(this.getNonContainedComponents());
    }

    private List<ComponentImplementingClassesLink> getNonContainedComponents() {
        ArrayList<ComponentImplementingClassesLink> nonContainedComponents = new ArrayList<ComponentImplementingClassesLink>();
        EList componentImplementingClassesLinks = this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink();
        for (ComponentImplementingClassesLink compLinkToCheckWhetherContained : componentImplementingClassesLinks) {
            boolean isComponentLinkToCheckContained = false;
            for (ComponentImplementingClassesLink potentialOuterCompLink : componentImplementingClassesLinks) {
                if (!potentialOuterCompLink.getSubComponents().contains((Object)compLinkToCheckWhetherContained)) continue;
                isComponentLinkToCheckContained = true;
                break;
            }
            if (isComponentLinkToCheckContained) continue;
            nonContainedComponents.add(compLinkToCheckWhetherContained);
            logger.debug((Object)("non-contained component: " + compLinkToCheckWhetherContained.getComponent().getEntityName() + " used for the system level"));
        }
        return nonContainedComponents;
    }

    private void buildSystemModel(List<ComponentImplementingClassesLink> innerComponents) {
        System pcmSystem = this.analysisResult.getSystemModel();
        pcmSystem.setEntityName("SoMoX Reverse Engineered System");
        PCMSystemImplementatingClassesLink pcmLink = SourcecodedecoratorFactory.eINSTANCE.createPCMSystemImplementatingClassesLink();
        pcmLink.setSystemModel(pcmSystem);
        HashSet<EndpointInformation> subComponentInformationSet = new HashSet<EndpointInformation>();
        ResourceEnvironment resourceEnvironment = DefaultResourceEnvironment.getDefaultResourceEnvironment();
        ResourceContainer defaultContainer = (ResourceContainer)resourceEnvironment.getResourceContainer_ResourceEnvironment().get(0);
        Allocation allocation = this.analysisResult.getAllocation();
        allocation.setEntityName("SoMoX Reverse Engineered Allocation Model");
        allocation.setSystem_Allocation(pcmSystem);
        allocation.setTargetResourceEnvironment_Allocation(resourceEnvironment);
        for (ComponentImplementingClassesLink compLink : innerComponents) {
            AssemblyContext assemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
            assemblyContext.setEncapsulatedComponent__AssemblyContext(compLink.getComponent());
            assemblyContext.setEntityName(compLink.getComponent().getEntityName());
            pcmSystem.getAssemblyContexts__ComposedStructure().add((Object)assemblyContext);
            pcmLink.getSubComponents().add((Object)compLink);
            AllocationContext allocationContext = AllocationFactory.eINSTANCE.createAllocationContext();
            allocation.getAllocationContexts_Allocation().add((Object)allocationContext);
            allocationContext.setAssemblyContext_AllocationContext(assemblyContext);
            allocationContext.setEntityName(compLink.getComponent().getEntityName());
            allocationContext.setResourceContainer_AllocationContext(defaultContainer);
            for (ProvidedRole role : compLink.getComponent().getProvidedRoles_InterfaceProvidingEntity()) {
                if (role instanceof OperationProvidedRole var14_14) {
                    this.createSystemProvidedRoleAndDelegationConnector(pcmSystem, compLink, assemblyContext, (OperationProvidedRole)opProvRole);
                    continue;
                }
                logger.warn((Object)("Role type not yet supported: " + role.getClass().getSimpleName()));
            }
        }
        this.componentBuilder.getInsideCompositeComponentAssemblyConnectorStrategy().buildAssemblyConnectors((ComposedProvidingRequiringEntity)pcmSystem, innerComponents);
        Iterable<EndpointInformation> subComponentInformation = InterfacePortBuilderHelper.collectInformationOnNonBoundInterfaces((ComponentImplementingClassesLink)pcmLink, (ComposedStructure)pcmSystem, false);
        Iterator<EndpointInformation> iterator = subComponentInformation.iterator();
        while (iterator.hasNext()) {
            subComponentInformationSet.add(iterator.next());
        }
    }

    private void createSystemProvidedRoleAndDelegationConnector(System pcmSystem, ComponentImplementingClassesLink compLink, AssemblyContext assemblyContext, OperationProvidedRole innerProvidedRole) {
        RepositoryComponent component = compLink.getComponent();
        String name = this.namingStrategy.createProvidedSystemPortName((Interface)innerProvidedRole.getProvidedInterface__OperationProvidedRole(), component);
        PCMSystemBuilder.createSystemProvidedRoleAndDelegationConnector(pcmSystem, assemblyContext, innerProvidedRole, name);
    }

    public static ProvidedDelegationConnector createSystemProvidedRoleAndDelegationConnector(System pcmSystem, AssemblyContext assemblyContext, OperationProvidedRole innerProvidedRole, String name) {
        OperationInterface opInterface = innerProvidedRole.getProvidedInterface__OperationProvidedRole();
        if (opInterface == null) {
            logger.error((Object)("No interface set for role: " + innerProvidedRole.getEntityName()));
            return null;
        }
        OperationProvidedRole outerProvidedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        outerProvidedRole.setProvidingEntity_ProvidedRole((InterfaceProvidingEntity)pcmSystem);
        outerProvidedRole.setEntityName(name);
        outerProvidedRole.setProvidedInterface__OperationProvidedRole(opInterface);
        ProvidedDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        delegationConnector.setAssemblyContext_ProvidedDelegationConnector(assemblyContext);
        delegationConnector.setInnerProvidedRole_ProvidedDelegationConnector(innerProvidedRole);
        delegationConnector.setOuterProvidedRole_ProvidedDelegationConnector(outerProvidedRole);
        delegationConnector.setParentStructure__Connector((ComposedStructure)pcmSystem);
        delegationConnector.setEntityName(opInterface.getEntityName());
        pcmSystem.getConnectors__ComposedStructure().add((Object)delegationConnector);
        return delegationConnector;
    }
}

