/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.simplemodelanalyzer.SimpleModelAnalyzer;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.gast2seff.jobs.SoMoXBlackboard;
import org.somox.ui.Activator;
import org.somox.ui.GUISoMoXCoreController;
import org.somox.ui.runconfig.SoMoXModelAnalyzerConfiguration;

public class SimpleModelAnalyzerJob
implements IBlackboardInteractingJob<SoMoXBlackboard> {
    private static Logger logger = Logger.getLogger(SimpleModelAnalyzerJob.class);
    private final GUISoMoXCoreController controller;
    private HashMap<String, String> globalPreferences = new HashMap();
    private final SoMoXConfiguration somoxConfiguration;
    private SoMoXBlackboard blackboard = null;

    public SimpleModelAnalyzerJob(SoMoXModelAnalyzerConfiguration config) throws CoreException {
        this.controller = this.getSoMoXController();
        this.somoxConfiguration = (SoMoXConfiguration)config.getMoxConfiguration();
        this.globalPreferences = this.getGlobalSoMoXPluginPreferences();
    }

    private GUISoMoXCoreController getSoMoXController() throws CoreException {
        GUISoMoXCoreController controller = Activator.getDefault().getGuiSoMoXCoreController();
        if (controller == null) {
            throw new CoreException((IStatus)new Status(4, "org.somox.analyzer.simplemodelanalyzer", "The SoMoX Core Controller can not be accessed. This indicates that the controller is not loaded yet. May be the SoMoX Core itself is not in place or not started yet."));
        }
        return controller;
    }

    private HashMap<String, String> getGlobalSoMoXPluginPreferences() throws CoreException {
        String[] availableProperties;
        HashMap<String, String> globalPreferences = new HashMap<String, String>();
        IEclipsePreferences pluginPreferences = new DefaultScope().getNode("org.somox.analyzer.simplemodelanalyzer");
        try {
            availableProperties = pluginPreferences.keys();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.somox.analyzer.simplemodelanalyzer", "SoMoX Setup failed", (Throwable)e));
        }
        String[] stringArray = availableProperties;
        int n = availableProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String availablePropertie = stringArray[n2];
            globalPreferences.put(availablePropertie, pluginPreferences.get(availablePropertie, ""));
            ++n2;
        }
        return globalPreferences;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        try {
            AnalysisResult result = this.controller.startAnalyze(SimpleModelAnalyzer.class.getName(), monitor, this.globalPreferences, this.somoxConfiguration);
            this.blackboard.setAnalysisResult(result);
        }
        catch (ModelAnalyzerException e) {
            throw new JobFailedException("SoMoX Failed", (Throwable)e);
        }
    }

    public String getName() {
        return "SoMoX Analyzer Job";
    }

    public void setBlackboard(SoMoXBlackboard blackBoard) {
        this.blackboard = blackBoard;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

