/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.QosannotationsFactory;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemFactory;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.SimpleAnalysisResult;
import org.somox.configuration.AbstractMoxConfiguration;
import org.somox.extractor.ExtractionResult;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;

public interface ModelAnalyzer<T extends AbstractMoxConfiguration> {
    public void init();

    public AnalysisResult analyze(T var1, HashMap<String, ExtractionResult> var2, IProgressMonitor var3) throws ModelAnalyzerException;

    public Status getStatus();

    default public SimpleAnalysisResult initializeAnalysisResult() {
        SimpleAnalysisResult analysisResult = new SimpleAnalysisResult(this);
        SourceCodeDecoratorRepository sourceCodeDecoratorRepository = SourcecodedecoratorFactory.eINSTANCE.createSourceCodeDecoratorRepository();
        System system = SystemFactory.eINSTANCE.createSystem();
        QoSAnnotations qosAnnotationModel = QosannotationsFactory.eINSTANCE.createQoSAnnotations();
        Repository newInternalArchitectureModel = RepositoryFactory.eINSTANCE.createRepository();
        Allocation allocation = AllocationFactory.eINSTANCE.createAllocation();
        analysisResult.setInternalArchitectureModel(newInternalArchitectureModel);
        analysisResult.setSourceCodeDecoratorRepository(sourceCodeDecoratorRepository);
        analysisResult.setSystemModel(system);
        analysisResult.setQosAnnotationModel(qosAnnotationModel);
        analysisResult.setAllocation(allocation);
        return analysisResult;
    }

    public static enum Status {
        READY,
        RUNNING,
        FINISHED,
        WAITING;

    }
}

