/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter.tests;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.somox.filter.BaseFilter;
import org.somox.filter.BlacklistFilter;
import org.somox.filter.tests.EmfResource;
import org.somox.filter.tests.JUnitAnnotationTestDetector;
import org.somox.filter.tests.MavenProjectStructureTestFileDetector;
import org.somox.filter.tests.TestDetector;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;

public class TestFileFilter
extends BaseFilter<ConcreteClassifier> {
    private static final Logger logger = Logger.getLogger(BlacklistFilter.class);
    private final Map<ConcreteClassifier, Boolean> cache = new HashMap<ConcreteClassifier, Boolean>();
    private final TestDetector[] detectors = new TestDetector[]{new MavenProjectStructureTestFileDetector(), new JUnitAnnotationTestDetector()};

    @Override
    public boolean passes(ConcreteClassifier object) {
        return this.cache.computeIfAbsent(object, this::isTestFile) == false;
    }

    private boolean isTestFile(ConcreteClassifier classifier) {
        CompilationUnit compilationUnit = classifier.getContainingCompilationUnit();
        if (compilationUnit == null) {
            return false;
        }
        Path compilationUnitPath = EmfResource.getPath(compilationUnit.eResource());
        if (compilationUnitPath == null) {
            return false;
        }
        boolean isTestFile = this.isTestFile(compilationUnitPath);
        if (isTestFile) {
            logger.debug((Object)("Excluded \"" + compilationUnitPath + "\" because it\u2019s a test file."));
        }
        return isTestFile;
    }

    private boolean isTestFile(Path file) {
        boolean mayBeTestFile = false;
        TestDetector[] testDetectorArray = this.detectors;
        int n = this.detectors.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                TestDetector detector = testDetectorArray[n2];
                if (!mayBeTestFile || detector.mayReturnFalse()) {
                    Optional<Boolean> result;
                    try {
                        result = detector.isTest(file);
                    }
                    catch (IOException iOException) {
                        break block6;
                    }
                    if (!result.orElse(true).booleanValue()) {
                        return false;
                    }
                    if (result.orElse(false).booleanValue()) {
                        mayBeTestFile = true;
                    }
                }
            }
            ++n2;
        }
        return mayBeTestFile;
    }
}

