/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.somox.filter.BaseFilter;
import org.somox.kdmhelper.KDMHelper;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.types.Type;

public class BlacklistFilter
extends BaseFilter<ConcreteClassifier> {
    private static Logger logger = Logger.getLogger(BlacklistFilter.class);
    private Pattern matchPattern = null;

    public BlacklistFilter() {
        this.matchPattern = Pattern.compile(".*");
    }

    public BlacklistFilter(Set<String> blacklist) {
        this.setBlacklist(blacklist);
    }

    public void setBlacklist(Set<String> blacklist) {
        this.matchPattern = BlacklistFilter.deriveMatchPattern(blacklist);
    }

    @Override
    public boolean passes(ConcreteClassifier object) {
        return !this.classMatchesBlacklist((Type)object);
    }

    private static Pattern deriveMatchPattern(Set<String> blacklist) {
        StringBuilder sw = new StringBuilder();
        for (String s : blacklist) {
            sw.append(s);
            sw.append("|");
        }
        if (sw.length() > 0) {
            sw.deleteCharAt(sw.length() - 1);
        }
        Pattern matchPattern = Pattern.compile(sw.toString(), 2);
        logger.debug((Object)("Initialised Blacklist filter with pattern " + matchPattern.toString()));
        return matchPattern;
    }

    private boolean classMatchesBlacklist(Type currentClass) {
        EObject container = currentClass.eContainer();
        if (container instanceof Member && (container instanceof ClassMethod || container instanceof Field || container instanceof InterfaceMethod)) {
            container = container.eContainer();
        }
        String fqn = KDMHelper.computeFullQualifiedName((Commentable)((Commentable)container));
        boolean result = this.matchPattern.matcher(fqn).matches();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Blacklist filter matches " + fqn + ": " + result));
        }
        return result;
    }
}

