/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter.tests;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.somox.filter.tests.EclipseAst;
import org.somox.filter.tests.EclipseAstFactory;
import org.somox.filter.tests.TestDetector;

public class JUnitAnnotationTestDetector
implements TestDetector {
    private static final Set<String> SEARCHED_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.Test", "org.junit.After", "org.junit.AfterClass", "org.junit.Before", "org.junit.BeforeClass"));
    private final EclipseAstFactory astFactory = new EclipseAstFactory();
    private Optional<IOException> ioError;

    @Override
    public Optional<Boolean> isTest(Path path) throws IOException {
        this.ioError = Optional.empty();
        CompilationUnit compilationUnit = this.astFactory.getCompilationUnit(path, true);
        boolean isTest = this.isTest(compilationUnit);
        if (this.ioError.isPresent()) {
            throw this.ioError.get();
        }
        if (isTest) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    private boolean isTest(ICompilationUnit sourceFile) {
        try {
            CompilationUnit compilationUnit = this.astFactory.getCompilationUnit(sourceFile, true);
            return this.isTest(compilationUnit);
        }
        catch (IOException ioException) {
            this.ioError = Optional.of(ioException);
            return false;
        }
    }

    private boolean isTest(CompilationUnit compilationUnit) {
        List containedTypes = compilationUnit.types();
        ITypeBinding objectType = compilationUnit.getAST().resolveWellKnownType("java.lang.Object");
        boolean hasJunit = containedTypes.stream().flatMap(EclipseAst::withSubDeclarations).filter(declaration -> declaration.getNodeType() == 31).map(declaration -> ((MethodDeclaration)declaration).resolveBinding()).filter(binding -> binding != null).flatMap(method -> Arrays.stream(method.getAnnotations())).anyMatch(annotation -> SEARCHED_ANNOTATIONS.contains(annotation.getAnnotationType().getQualifiedName()));
        if (hasJunit) {
            return true;
        }
        return containedTypes.stream().flatMap(EclipseAst::withSubDeclarations).filter(EclipseAst::isTypeDeclaration).map(type -> ((AbstractTypeDeclaration)type).resolveBinding()).filter(binding -> binding != null).map(ITypeBinding::getSuperclass).filter(superclass -> superclass != null && superclass != objectType).map(IBinding::getJavaElement).filter(javaElement -> javaElement != null && javaElement.getElementType() == 5).anyMatch(parentUnit -> this.isTest((ICompilationUnit)parentUnit));
    }

    @Override
    public boolean mayReturnFalse() {
        return false;
    }
}

