/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.somox.analyzer.AnalysisResult;
import org.somox.gast2seff.jobs.DefaultQosAnnotationsBuilder;
import org.somox.gast2seff.jobs.SoMoXBlackboard;
import org.somox.gast2seff.visitors.DefaultResourceDemandingBehaviourForClassMethodFinder;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategyFactory;
import org.somox.gast2seff.visitors.InterfaceOfExternalCallFindingFactory;
import org.somox.gast2seff.visitors.MethodCallFinder;
import org.somox.gast2seff.visitors.VisitorUtils;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.SEFF2MethodMapping;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;

public class GAST2SEFFJob
implements IBlackboardInteractingJob<SoMoXBlackboard> {
    private final Logger logger = Logger.getLogger(GAST2SEFFJob.class);
    private SoMoXBlackboard blackboard;
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private SourceCodeDecoratorRepository sourceCodeDecoratorModel;
    private Root root;
    private FunctionCallClassificationVisitor typeVisitor;
    private MethodCallFinder methodCallFinder;
    private final boolean createResourceDemandingInternalBehaviour;
    private final IFunctionClassificationStrategyFactory iFunctionClassificationStrategyFactory;
    private final InterfaceOfExternalCallFindingFactory interfaceOfExternalCallFindingFactory;

    public GAST2SEFFJob() {
        this(false, new IFunctionClassificationStrategyFactory(){}, new InterfaceOfExternalCallFindingFactory(){});
    }

    public GAST2SEFFJob(boolean createResourceDemandingInternalBehaviour) {
        this(createResourceDemandingInternalBehaviour, new IFunctionClassificationStrategyFactory(){}, new InterfaceOfExternalCallFindingFactory(){});
    }

    public GAST2SEFFJob(boolean createResourceDemandingInternalBehaviour, IFunctionClassificationStrategyFactory iFunctionClassificationStrategyFactory, InterfaceOfExternalCallFindingFactory interfaceOfExternalCallFindingFactory) {
        this.createResourceDemandingInternalBehaviour = createResourceDemandingInternalBehaviour;
        this.iFunctionClassificationStrategyFactory = iFunctionClassificationStrategyFactory;
        this.interfaceOfExternalCallFindingFactory = interfaceOfExternalCallFindingFactory;
        HashMap cache = new HashMap();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(cache);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.subTask("loading models from blackboard");
        AnalysisResult result = this.blackboard.getAnalysisResult();
        this.sourceCodeDecoratorModel = result.getSourceCodeDecoratorRepository();
        this.root = result.getRoot();
        this.methodCallFinder = new MethodCallFinder();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        subMonitor.setTaskName("Creating SEFF behaviour");
        for (SEFF2MethodMapping astBehaviour : this.sourceCodeDecoratorModel.getSeff2MethodMappings()) {
            ResourceDemandingSEFF seff = (ResourceDemandingSEFF)astBehaviour.getSeff();
            String name = seff.getId();
            this.logger.info((Object)("Found AST behaviour, generating SEFF behaviour for it: " + name));
            this.generateSEFFForGASTBehaviour(seff);
            monitor.worked(1);
        }
        DefaultQosAnnotationsBuilder qosAnnotationBuilder = new DefaultQosAnnotationsBuilder();
        qosAnnotationBuilder.buildDefaultQosAnnotations((EList<SEFF2MethodMapping>)this.sourceCodeDecoratorModel.getSeff2MethodMappings());
        subMonitor.done();
    }

    public String getName() {
        return "GAST2SEFF Transformation Job";
    }

    private ResourceDemandingSEFF createSeff(ResourceDemandingSEFF seff) throws JobFailedException {
        StartAction start = SeffFactory.eINSTANCE.createStartAction();
        StopAction stop = SeffFactory.eINSTANCE.createStopAction();
        seff.getSteps_Behaviour().add((Object)start);
        BasicComponent basicComponent = (BasicComponent)seff.eContainer();
        IFunctionClassificationStrategy basicFunctionClassifierStrategy = this.iFunctionClassificationStrategyFactory.createIFunctionClassificationStrategy(this.sourceCodeDecoratorModel, basicComponent, this.root, this.methodCallFinder);
        this.typeVisitor = new FunctionCallClassificationVisitor(basicFunctionClassifierStrategy, this.methodCallFinder);
        StatementListContainer body = this.findBody(seff);
        this.logger.trace((Object)("visiting (seff entry): " + seff.getId()));
        if (body != null) {
            if (this.createResourceDemandingInternalBehaviour) {
                DefaultResourceDemandingBehaviourForClassMethodFinder defaultResourceDemandingBehaviourForClassMethodFinder = new DefaultResourceDemandingBehaviourForClassMethodFinder(this.sourceCodeDecoratorModel, basicComponent);
                VisitorUtils.visitJaMoPPMethod((ResourceDemandingBehaviour)seff, basicComponent, body, this.sourceCodeDecoratorModel, this.typeVisitor, this.interfaceOfExternalCallFindingFactory, defaultResourceDemandingBehaviourForClassMethodFinder, this.methodCallFinder);
            } else {
                VisitorUtils.visitJaMoPPMethod((ResourceDemandingBehaviour)seff, basicComponent, body, this.sourceCodeDecoratorModel, this.typeVisitor, this.interfaceOfExternalCallFindingFactory, this.methodCallFinder);
            }
        } else {
            this.logger.warn((Object)("Found GAST behaviour (" + seff.getId() + ") without a method body... Skipping it..."));
        }
        seff.getSteps_Behaviour().add((Object)stop);
        VisitorUtils.connectActions((ResourceDemandingBehaviour)seff);
        return seff;
    }

    private StatementListContainer findBody(ResourceDemandingSEFF seff) throws JobFailedException {
        this.onlyOnceAsGastBehaviour((EList<SEFF2MethodMapping>)this.sourceCodeDecoratorModel.getSeff2MethodMappings(), (ServiceEffectSpecification)seff);
        for (SEFF2MethodMapping behaviour : this.sourceCodeDecoratorModel.getSeff2MethodMappings()) {
            if (!((ResourceDemandingSEFF)behaviour.getSeff()).getId().equals(seff.getId())) continue;
            this.logger.debug((Object)("Matching SEFF found " + seff.getId()));
            return behaviour.getStatementListContainer();
        }
        this.logger.warn((Object)("Checked gastBehaviourRepository for " + seff.getId() + " but found none"));
        throw new JobFailedException("Unable to find operation body for given method");
    }

    private boolean onlyOnceAsGastBehaviour(EList<SEFF2MethodMapping> seff2MethodMappings, ServiceEffectSpecification seff) {
        int i = 0;
        for (SEFF2MethodMapping mapping : seff2MethodMappings) {
            ResourceDemandingSEFF seffMapping = (ResourceDemandingSEFF)mapping.getSeff();
            ResourceDemandingSEFF seffInput = (ResourceDemandingSEFF)seff;
            if (!seffMapping.getId().equals(seffInput.getId())) continue;
            ++i;
        }
        if (i != 1) {
            this.logger.error((Object)("Assertion fails - onlyOnceAsGastBehaviour: i = " + i + " for " + ((ResourceDemandingSEFF)seff).getId()));
        }
        return i == 1;
    }

    private ResourceDemandingSEFF generateSEFFForGASTBehaviour(ResourceDemandingSEFF gastBehaviourStub) throws JobFailedException {
        this.createSeff(gastBehaviourStub);
        return gastBehaviourStub;
    }

    public void setBlackboard(SoMoXBlackboard blackBoard) {
        this.blackboard = blackBoard;
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

