/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.MethodCallFinder;
import org.somox.kdmhelper.KDMHelper;
import tools.mdsd.jamopp.commons.layout.LayoutInformation;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.members.util.MembersSwitch;
import tools.mdsd.jamopp.model.java.statements.Assert;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.DoWhileLoop;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.Jump;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.model.java.statements.util.StatementsSwitch;

public abstract class AbstractJaMoPPStatementVisitor
extends ComposedSwitch<Object> {
    private static final Logger logger = Logger.getLogger(AbstractJaMoPPStatementVisitor.class);
    protected final Map<Commentable, List<BitSet>> functionClassificationAnnotation;
    protected BitSet lastType = null;
    protected boolean doNotSkipNextStatement = false;
    protected MethodCallFinder methodCallFinder;

    public AbstractJaMoPPStatementVisitor(Map<Commentable, List<BitSet>> functionClassificationAnnotations, MethodCallFinder methodCallFinder) {
        this.functionClassificationAnnotation = functionClassificationAnnotations;
        this.methodCallFinder = methodCallFinder;
        this.addSwitch((org.eclipse.emf.ecore.util.Switch)new MemberVisitor());
        this.addSwitch((org.eclipse.emf.ecore.util.Switch)new StatementVisitor());
    }

    protected abstract Object handleLoopStatement(Statement var1, Statement var2);

    protected abstract Object handleCondition(Condition var1);

    protected abstract Object handleSwitch(Switch var1);

    protected abstract Object handleClassMethod(ClassMethod var1, Statement var2);

    protected abstract Object handleTryBlock(TryBlock var1);

    protected Object handleSynchronizedBlock(SynchronizedBlock synchronizedBlock) {
        return null;
    }

    protected abstract void foundInternalAction(Statement var1);

    protected abstract void foundExternalCall(Statement var1, Method var2, BitSet var3);

    protected void foundEmitEventAction(Statement object, Method calledMethod, BitSet statementAnnotation) {
        this.foundInternalAction(object);
    }

    protected Object handleStatementListContainer(StatementListContainer object) {
        for (Statement s : object.getStatements()) {
            Collection thisTypes = this.functionClassificationAnnotation.get(s);
            if (thisTypes == null) {
                logger.info((Object)"thisTypes == null - continue with next statement");
                continue;
            }
            for (BitSet thisType : thisTypes) {
                if (!this.shouldSkip(this.lastType, thisType) && !this.isVisitedStatement(thisType)) {
                    this.setVisited(thisTypes);
                    this.doSwitch((EObject)s);
                }
                this.lastType = thisType;
            }
        }
        return new Object();
    }

    protected Object handleFormerSimpleStatement(Statement object) {
        List<BitSet> statementAnnotations = this.functionClassificationAnnotation.get(object);
        List<Method> calledMethods = this.methodCallFinder.getMethodCalls(object);
        if (calledMethods.size() > 0) {
            int i = 0;
            while (i < statementAnnotations.size()) {
                BitSet statementAnnotation = statementAnnotations.get(i);
                if (this.isExternalCall(statementAnnotation)) {
                    calledMethod = calledMethods.get(i);
                    this.foundExternalCall(object, calledMethod, statementAnnotation);
                } else if (this.isEmitEventCall(statementAnnotation)) {
                    calledMethod = calledMethods.get(i);
                    this.foundEmitEventAction(object, calledMethod, statementAnnotation);
                } else if (this.isInternalCall(statementAnnotation)) {
                    if (calledMethods.size() != 0) {
                        Method method = null;
                        method = i + 1 > calledMethods.size() ? calledMethods.get(0) : calledMethods.get(i);
                        if (!(method instanceof ClassMethod var7_7)) {
                            logger.error((Object)"Referenceable element must be a class method");
                        } else if (classMethod.getStatements() != null) {
                            this.handleClassMethod((ClassMethod)classMethod, object);
                        } else {
                            StringBuilder msg = new StringBuilder("Behaviour not set in GAST for ").append(method.getName());
                            if (KDMHelper.getJavaNodeSourceRegion((Commentable)object) != null && KDMHelper.getJavaNodeSourceRegion((Commentable)object).getNamespacesAsString() != null) {
                                msg.append(". Tried to call from ").append(KDMHelper.getJavaNodeSourceRegion((Commentable)object).getNamespacesAsString()).append(".");
                            } else {
                                msg.append(". (caller position unknown)");
                            }
                            logger.warn((Object)msg.toString());
                        }
                    }
                } else {
                    this.foundInternalAction(object);
                }
                ++i;
            }
        } else {
            this.foundInternalAction(object);
        }
        return new Object();
    }

    private void setVisited(Collection<BitSet> thisTypes) {
        for (BitSet thisType : thisTypes) {
            this.setVisited(thisType);
        }
    }

    public Object defaultCase(EObject object) {
        logger.warn((Object)("Not handled object by statement visitor:\n  " + object));
        return super.defaultCase(object);
    }

    protected boolean containsExternalCall(Statement object) {
        Collection statementTypes = this.functionClassificationAnnotation.get(object);
        for (BitSet statementType : statementTypes) {
            boolean isExternalCall = statementType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
            boolean isInternalCallContainingExternalCall = statementType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL_CALL_CONTAINING_EXTERNAL_CALL));
            boolean isEmitEventCall = statementType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EMITEVENT));
            if (!isExternalCall && !isInternalCallContainingExternalCall && !isEmitEventCall) continue;
            return true;
        }
        return false;
    }

    protected boolean isVisitedStatement(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED));
    }

    protected void setVisited(BitSet thisType) {
        thisType.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED), true);
    }

    protected String positionToString(Commentable position) {
        StringBuilder positionString = new StringBuilder(" @position: ");
        if (position != null) {
            positionString.append(KDMHelper.computeFullQualifiedName((Commentable)position));
            if (position.getLayoutInformations() != null && position.getLayoutInformations().size() > 0 && position.getLayoutInformations().get(0) != null) {
                int startPos = ((LayoutInformation)position.getLayoutInformations().get(0)).getStartOffset();
                int layoutSize = position.getLayoutInformations().size();
                int endPos = ((LayoutInformation)position.getLayoutInformations().get(layoutSize - 1)).getStartOffset();
                if (startPos != endPos) {
                    positionString.append(" from ").append(startPos).append(" to ").append(endPos);
                } else {
                    positionString.append(" at ").append(startPos);
                }
            } else {
                positionString.append(" unknown exact possition");
            }
        } else {
            positionString.append("no position information available");
        }
        return positionString.toString();
    }

    protected String positionToLineNumber(CompilationUnit position) {
        StringBuilder positionString = new StringBuilder("line ");
        if (position != null) {
            positionString.append(((LayoutInformation)position.getLayoutInformations().get(0)).getStartOffset());
        } else {
            positionString.append("no position information available");
        }
        return positionString.toString();
    }

    protected boolean isExternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    protected boolean isEmitEventCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EMITEVENT));
    }

    protected boolean isInternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
    }

    protected boolean isInternalCallContainingExternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL_CALL_CONTAINING_EXTERNAL_CALL));
    }

    protected boolean isLibraryCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.LIBRARY));
    }

    protected boolean shouldSkip(BitSet lastType, BitSet thisType) {
        if (this.doNotSkipNextStatement) {
            this.doNotSkipNextStatement = false;
            this.lastType = null;
            return false;
        }
        if (lastType == null || this.isExternalCall(thisType) || this.isInternalCallContainingExternalCall(thisType) || this.isEmitEventCall(thisType)) {
            return false;
        }
        return !this.isExternalCall(lastType) && !this.isEmitEventCall(lastType);
    }

    private class MemberVisitor
    extends MembersSwitch<Object> {
        private MemberVisitor() {
        }

        public Object caseStatementListContainer(StatementListContainer object) {
            return AbstractJaMoPPStatementVisitor.this.handleStatementListContainer(object);
        }

        public Object caseClassMethod(ClassMethod classMethod) {
            return AbstractJaMoPPStatementVisitor.this.handleClassMethod(classMethod, null);
        }
    }

    private class StatementVisitor
    extends StatementsSwitch<Object> {
        private StatementVisitor() {
        }

        public Object caseSwitch(Switch switchStatement) {
            return AbstractJaMoPPStatementVisitor.this.handleSwitch(switchStatement);
        }

        public Object caseCondition(Condition condition) {
            return AbstractJaMoPPStatementVisitor.this.handleCondition(condition);
        }

        public Object caseBlock(Block block) {
            return AbstractJaMoPPStatementVisitor.this.handleStatementListContainer((StatementListContainer)block);
        }

        public Object caseForEachLoop(ForEachLoop object) {
            return AbstractJaMoPPStatementVisitor.this.handleLoopStatement((Statement)object, object.getStatement());
        }

        public Object caseForLoop(ForLoop object) {
            return AbstractJaMoPPStatementVisitor.this.handleLoopStatement((Statement)object, object.getStatement());
        }

        public Object caseWhileLoop(WhileLoop object) {
            return AbstractJaMoPPStatementVisitor.this.handleLoopStatement((Statement)object, object.getStatement());
        }

        public Object caseDoWhileLoop(DoWhileLoop object) {
            return AbstractJaMoPPStatementVisitor.this.handleLoopStatement((Statement)object, object.getStatement());
        }

        public Object caseTryBlock(TryBlock object) {
            return AbstractJaMoPPStatementVisitor.this.handleTryBlock(object);
        }

        public Object caseSynchronizedBlock(SynchronizedBlock synchronizedBlock) {
            return AbstractJaMoPPStatementVisitor.this.handleSynchronizedBlock(synchronizedBlock);
        }

        public Object caseExpressionStatement(ExpressionStatement object) {
            return AbstractJaMoPPStatementVisitor.this.handleFormerSimpleStatement((Statement)object);
        }

        public Object caseLocalVariableStatement(LocalVariableStatement object) {
            return AbstractJaMoPPStatementVisitor.this.handleFormerSimpleStatement((Statement)object);
        }

        public Object caseAssert(Assert object) {
            return AbstractJaMoPPStatementVisitor.this.handleFormerSimpleStatement((Statement)object);
        }

        public Object caseStatement(Statement statement) {
            return AbstractJaMoPPStatementVisitor.this.handleFormerSimpleStatement(statement);
        }

        public Object caseJump(Jump jump) {
            return new Object();
        }

        public Object defaultCase(EObject object) {
            return AbstractJaMoPPStatementVisitor.this.defaultCase(object);
        }
    }
}

