/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;
import org.somox.analyzer.AnalysisResult;
import org.somox.configuration.AbstractMoxConfiguration;
import org.somox.gast2seff.jobs.SoMoXBlackboard;
import org.somox.kdmhelper.SoMoXUtil;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.util.DefaultResourceEnvironment;

public class SaveSoMoXModelsJob
implements IBlackboardInteractingJob<SoMoXBlackboard> {
    private static final String PATH_SEPARATOR = "/";
    private static final String PATH_SOURCECODE_DECORATOR_REPOSITORY = "internal_architecture_model.sourcecodedecorator";
    private static final String PATH_SYSTEM_MODEL = "internal_architecture_model.system";
    private static final String PATH_QOS_ANNOTATIONS_MODEL = "internal_architecture_model.samm_qosannotation";
    private static final String PATH_REPOSITORY_MODEL = "internal_architecture_model.repository";
    private static final String PATH_ALLOCATION_MODEL = "internal_architecture_model.allocation";
    private static final String PATH_RESOURCE_ENVIRONMENT_MODEL = "internal_architecture_model.resourceenvironment";
    private final Logger logger = Logger.getLogger(SaveSoMoXModelsJob.class);
    private SoMoXBlackboard blackboard = null;
    private ResourceSet resourceSet = null;
    private AbstractMoxConfiguration somoxConfiguration = null;

    public SaveSoMoXModelsJob(AbstractMoxConfiguration somoxConfiguration) {
        this.somoxConfiguration = somoxConfiguration;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public void setBlackboard(SoMoXBlackboard blackBoard) {
        this.blackboard = blackBoard;
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        boolean isValidURI;
        AnalysisResult result = this.blackboard.getAnalysisResult();
        String outputFolder = this.somoxConfiguration.getFileLocations().getOutputFolder();
        URI outputFolderURI = null;
        try {
            outputFolderURI = URI.createURI((String)outputFolder);
            isValidURI = outputFolderURI.isPlatformResource() || outputFolderURI.isFile();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isValidURI = false;
        }
        try {
            if (isValidURI) {
                this.saveRepositoryModel(result.getInternalArchitectureModel(), outputFolderURI);
                this.saveSourceCodeDecoratorRepository(result.getSourceCodeDecoratorRepository(), outputFolderURI);
                this.saveSystemModel(result.getSystemModel(), outputFolderURI);
                this.saveQoSAnnotationsModel(result.getQosAnnotationModel(), outputFolderURI);
                this.saveResourceEnvironmentModel(DefaultResourceEnvironment.getDefaultResourceEnvironment(), outputFolderURI);
                this.saveAllocationModel(result.getAllocation(), outputFolderURI);
            } else {
                this.saveRepositoryModel(result.getInternalArchitectureModel(), outputFolder);
                this.saveSourceCodeDecoratorRepository(result.getSourceCodeDecoratorRepository(), outputFolder);
                this.saveSystemModel(result.getSystemModel(), outputFolder);
                this.saveQoSAnnotationsModel(result.getQosAnnotationModel(), outputFolder);
                this.saveResourceEnvironmentModel(DefaultResourceEnvironment.getDefaultResourceEnvironment(), outputFolder);
                this.saveAllocationModel(result.getAllocation(), outputFolder);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Model Analyzer failed.", (Throwable)e);
            throw new JobFailedException("Unable to save SoMoX Models", (Throwable)e);
        }
    }

    private void saveSourceCodeDecoratorRepository(SourceCodeDecoratorRepository repository, String outputFolder) throws IOException {
        this.save((EObject)repository, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_SOURCECODE_DECORATOR_REPOSITORY);
    }

    private void saveSourceCodeDecoratorRepository(SourceCodeDecoratorRepository repository, URI outputFolder) throws IOException {
        this.save((EObject)repository, outputFolder.appendSegment(PATH_SOURCECODE_DECORATOR_REPOSITORY));
    }

    private void saveSystemModel(System system, String outputFolder) throws IOException {
        this.save((EObject)system, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_SYSTEM_MODEL);
    }

    private void saveSystemModel(System system, URI outputFolder) throws IOException {
        this.save((EObject)system, outputFolder.appendSegment(PATH_SYSTEM_MODEL));
    }

    private void saveQoSAnnotationsModel(QoSAnnotations serviceArchitectureModel, String outputFolder) throws IOException {
        this.save((EObject)serviceArchitectureModel, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_QOS_ANNOTATIONS_MODEL);
    }

    private void saveQoSAnnotationsModel(QoSAnnotations serviceArchitectureModel, URI outputFolder) throws IOException {
        this.save((EObject)serviceArchitectureModel, outputFolder.appendSegment(PATH_QOS_ANNOTATIONS_MODEL));
    }

    private void saveRepositoryModel(Repository repository, String outputFolder) throws IOException {
        this.save((EObject)repository, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_REPOSITORY_MODEL);
    }

    private void saveRepositoryModel(Repository repository, URI outputFolder) throws IOException {
        this.save((EObject)repository, outputFolder.appendSegment(PATH_REPOSITORY_MODEL));
    }

    private void saveAllocationModel(Allocation allocation, String outputFolder) throws IOException {
        this.save((EObject)allocation, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_ALLOCATION_MODEL);
    }

    private void saveAllocationModel(Allocation allocation, URI outputFolder) throws IOException {
        this.save((EObject)allocation, outputFolder.appendSegment(PATH_ALLOCATION_MODEL));
    }

    private void saveResourceEnvironmentModel(ResourceEnvironment resourceEnvironment, String outputFolder) throws IOException {
        this.save((EObject)resourceEnvironment, String.valueOf(outputFolder) + PATH_SEPARATOR + PATH_RESOURCE_ENVIRONMENT_MODEL);
    }

    private void saveResourceEnvironmentModel(ResourceEnvironment resourceEnvironment, URI outputFolder) throws IOException {
        this.save((EObject)resourceEnvironment, outputFolder.appendSegment(PATH_RESOURCE_ENVIRONMENT_MODEL));
    }

    private void save(EObject emfObject, String path) throws IOException {
        URI uri = null;
        uri = !SoMoXUtil.isStandalone() ? URI.createPlatformResourceURI((String)path, (boolean)true) : URI.createFileURI((String)path);
        this.save(emfObject, uri);
    }

    private void save(EObject emfObject, URI uri) throws IOException {
        Resource resource = this.resourceSet.createResource(uri);
        resource.getContents().add((Object)emfObject);
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        resource.save(saveOptions);
    }

    public String getName() {
        return "Save SoMoX Models Job";
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

