/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.somox.gast2seff.visitors.AbstractLibraryCallFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.MethodCallFinder;
import org.somox.kdmhelper.EqualityChecker;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Method;

public class BasicFunctionClassificationStrategy
extends AbstractLibraryCallFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    static Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);
    private final BasicComponent primitiveComponent;
    protected final SourceCodeDecoratorRepository sourceCodeDecoratorRepository;

    public BasicFunctionClassificationStrategy(SourceCodeDecoratorRepository sourceCodeDecoratorRepository, BasicComponent primitiveComponent, Root root, MethodCallFinder methodCallFinder) {
        super(root, sourceCodeDecoratorRepository, methodCallFinder);
        this.sourceCodeDecoratorRepository = sourceCodeDecoratorRepository;
        this.primitiveComponent = primitiveComponent;
    }

    @Override
    protected boolean isExternalCall(Method method) {
        ComponentImplementingClassesLink compLink = this.queryComponentLink(this.primitiveComponent);
        if (compLink == null) {
            return false;
        }
        for (InterfaceSourceCodeLink ifLink : compLink.getRequiredInterfaces()) {
            List methodsInInterface = KDMHelper.getMethods((ConcreteClassifier)ifLink.getGastClass());
            for (Method methodInInterface : methodsInInterface) {
                if (!EqualityChecker.areFunctionsEqual((Method)method, (Method)methodInInterface)) continue;
                logger.debug((Object)("Classified call as external call: " + method.getName() + " for component " + this.primitiveComponent.getEntityName()));
                return true;
            }
        }
        logger.trace((Object)("no external call: " + method.getName()));
        return false;
    }

    private ComponentImplementingClassesLink queryComponentLink(BasicComponent primitiveComponent) {
        for (ComponentImplementingClassesLink compLink : this.sourceCodeDecoratorRepository.getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(primitiveComponent)) continue;
            return compLink;
        }
        String msg = "Could not find a component implementing classes link in the source code decorator for component " + primitiveComponent;
        logger.warn((Object)msg);
        return null;
    }
}

