/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.somox.gast2seff.visitors.InterfaceOfExternalCallFinding;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.Statement;

public class DefaultInterfaceOfExternalCallFinder
implements InterfaceOfExternalCallFinding {
    private static final Logger logger = Logger.getLogger((String)DefaultInterfaceOfExternalCallFinder.class.getSimpleName());
    private final SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private final BasicComponent basicComponent;

    public DefaultInterfaceOfExternalCallFinder(SourceCodeDecoratorRepository sourceCodeDecoratorRepository, BasicComponent basicComponent) {
        this.sourceCodeDecoratorRepository = sourceCodeDecoratorRepository;
        this.basicComponent = basicComponent;
    }

    @Override
    public InterfaceOfExternalCallFinding.InterfacePortOperationTuple getCalledInterfacePort(Method calledMethod, Statement statement) {
        InterfaceOfExternalCallFinding.InterfacePortOperationTuple interfacePortOperationTuple = new InterfaceOfExternalCallFinding.InterfacePortOperationTuple();
        ConcreteClassifier accessedConcreteClassifier = calledMethod.getContainingConcreteClassifier();
        for (RequiredRole requiredRole : this.getBasicComponent().getRequiredRoles_InterfaceRequiringEntity()) {
            Interface pcmInterface = this.getInterfaceFromRequiredRole(requiredRole);
            for (InterfaceSourceCodeLink ifLink : this.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink()) {
                ConcreteClassifier gastClass;
                if (pcmInterface == null || !pcmInterface.equals(ifLink.getInterface()) || !(gastClass = ifLink.getGastClass()).equals(accessedConcreteClassifier)) continue;
                logger.trace((Object)("accessed interface port " + requiredRole.getEntityName()));
                interfacePortOperationTuple.role = requiredRole;
                interfacePortOperationTuple.signature = this.queryInterfaceOperation(calledMethod);
                return interfacePortOperationTuple;
            }
        }
        logger.warn((Object)("found no if port for " + accessedConcreteClassifier));
        return interfacePortOperationTuple;
    }

    protected SourceCodeDecoratorRepository getSourceCodeDecoratorRepository() {
        return this.sourceCodeDecoratorRepository;
    }

    protected BasicComponent getBasicComponent() {
        return this.basicComponent;
    }

    private Interface getInterfaceFromRequiredRole(RequiredRole requiredRole) {
        RequiredRole requiredRole2 = requiredRole;
        if (requiredRole2 instanceof OperationRequiredRole && (var2_3 = (OperationRequiredRole)requiredRole2) == (OperationRequiredRole)var3_2) {
            return operReqRole.getRequiredInterface__OperationRequiredRole();
        }
        if (requiredRole instanceof SourceRole var4_5) {
            return sourceRole.getEventGroup__SourceRole();
        }
        return null;
    }

    private Signature queryInterfaceOperation(Method invokedMethod) {
        for (MethodLevelSourceCodeLink methodLink : this.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            Member methodSourceCodeDecorator = methodLink.getFunction();
            if (!methodSourceCodeDecorator.equals(invokedMethod)) continue;
            logger.trace((Object)("accessed operation " + methodLink.getOperation().getEntityName()));
            return methodLink.getOperation();
        }
        logger.warn((Object)("no accessed operation found for " + invokedMethod.getContainingConcreteClassifier() + "::" + invokedMethod.getName()));
        return null;
    }
}

