/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.EmitEventAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.InternalCallAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingInternalBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.somox.gast2seff.visitors.AbstractJaMoPPStatementVisitor;
import org.somox.gast2seff.visitors.DefaultInterfaceOfExternalCallFinder;
import org.somox.gast2seff.visitors.InterfaceOfExternalCallFinding;
import org.somox.gast2seff.visitors.InterfaceOfExternalCallFindingFactory;
import org.somox.gast2seff.visitors.MethodCallFinder;
import org.somox.gast2seff.visitors.ResourceDemandingBehaviourForClassMethodFinding;
import org.somox.gast2seff.visitors.SwitchStatementHelper;
import org.somox.gast2seff.visitors.VisitorUtils;
import org.somox.kdmhelper.KDMHelper;
import org.somox.sourcecodedecorator.AbstractActionClassMethodLink;
import org.somox.sourcecodedecorator.MethodLevelResourceDemandingInternalBehaviorLink;
import org.somox.sourcecodedecorator.SeffElementSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.sourcecodedecorator.SourcecodedecoratorFactory;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.model.java.statements.TryBlock;

public class JaMoPPStatementVisitor
extends AbstractJaMoPPStatementVisitor {
    private static final Logger logger = Logger.getLogger(JaMoPPStatementVisitor.class);
    private final ResourceDemandingBehaviour seff;
    private final SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private final BasicComponent primitiveComponent;
    private final InterfaceOfExternalCallFinding interfaceOfExternalCallFinder;
    private final ResourceDemandingBehaviourForClassMethodFinding resourceDemandingBehaviourForClassMethodFinding;
    private final Map<Identifier, SeffElementSourceCodeLink> seffElemestSourceCodeLinks = new HashMap<Identifier, SeffElementSourceCodeLink>();
    private InternalAction lastInternalAction;

    public JaMoPPStatementVisitor(Map<Commentable, List<BitSet>> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour, SourceCodeDecoratorRepository sourceCodeDecorator, BasicComponent primitiveComponent, MethodCallFinder methodCallFinder) {
        this(functionClassificationAnnotations, resourceDemandingBehaviour, sourceCodeDecorator, primitiveComponent, new InterfaceOfExternalCallFindingFactory(){}, null, methodCallFinder);
    }

    public JaMoPPStatementVisitor(Map<Commentable, List<BitSet>> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour, SourceCodeDecoratorRepository sourceCodeDecorator, BasicComponent primitiveComponent, InterfaceOfExternalCallFindingFactory interfaceOfExternalCallFinderFactory, ResourceDemandingBehaviourForClassMethodFinding resourceDemandingBehaviourForClassMethodFinding, MethodCallFinder methodCallFinder) {
        this(functionClassificationAnnotations, resourceDemandingBehaviour, sourceCodeDecorator, primitiveComponent, interfaceOfExternalCallFinderFactory.createInterfaceOfExternalCallFinding(sourceCodeDecorator, primitiveComponent), resourceDemandingBehaviourForClassMethodFinding, methodCallFinder);
    }

    private JaMoPPStatementVisitor(Map<Commentable, List<BitSet>> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour, SourceCodeDecoratorRepository sourceCodeDecorator, BasicComponent primitiveComponent, InterfaceOfExternalCallFinding interfaceOfExternalCallFinder, ResourceDemandingBehaviourForClassMethodFinding resourceDemandingBehaviourForClassMethodFinding, MethodCallFinder methodCallFinder) {
        super(functionClassificationAnnotations, methodCallFinder);
        this.seff = resourceDemandingBehaviour;
        this.sourceCodeDecoratorRepository = sourceCodeDecorator;
        this.primitiveComponent = primitiveComponent;
        this.resourceDemandingBehaviourForClassMethodFinding = resourceDemandingBehaviourForClassMethodFinding;
        this.interfaceOfExternalCallFinder = this.configureInterfaceOfExternalCallFinding(sourceCodeDecorator, primitiveComponent, interfaceOfExternalCallFinder);
    }

    private InterfaceOfExternalCallFinding configureInterfaceOfExternalCallFinding(SourceCodeDecoratorRepository sourceCodeDecorator, BasicComponent primitiveComponent, InterfaceOfExternalCallFinding interfaceOfExternalCallFinder) {
        if (interfaceOfExternalCallFinder != null) {
            return interfaceOfExternalCallFinder;
        }
        if (sourceCodeDecorator == null) {
            throw new IllegalArgumentException("Can not use " + DefaultInterfaceOfExternalCallFinder.class.getSimpleName() + " with \u2018null' for source code decorator");
        }
        return new DefaultInterfaceOfExternalCallFinder(sourceCodeDecorator, primitiveComponent);
    }

    @Override
    protected Object handleLoopStatement(Statement loopStatement, Statement body) {
        if (this.containsExternalCall(loopStatement)) {
            LoopAction loop = SeffFactory.eINSTANCE.createLoopAction();
            this.createAbstracActionClassMethodLink((AbstractAction)loop, loopStatement);
            this.linkSeffElement((Identifier)loop, loopStatement);
            loop.setBodyBehaviour_Loop(SeffFactory.eINSTANCE.createResourceDemandingBehaviour());
            this.seff.getSteps_Behaviour().add((Object)loop);
            StartAction startAction = SeffFactory.eINSTANCE.createStartAction();
            loop.getBodyBehaviour_Loop().getSteps_Behaviour().add((Object)startAction);
            this.createAbstracActionClassMethodLink((AbstractAction)startAction, loopStatement);
            loop.setEntityName(this.positionToString((Commentable)loopStatement));
            new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, loop.getBodyBehaviour_Loop(), this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder).doSwitch((EObject)body);
            StopAction stopAction = SeffFactory.eINSTANCE.createStopAction();
            this.createAbstracActionClassMethodLink((AbstractAction)stopAction, loopStatement);
            loop.getBodyBehaviour_Loop().getSteps_Behaviour().add((Object)stopAction);
            VisitorUtils.connectActions(loop.getBodyBehaviour_Loop());
        } else {
            this.createInternalAction(loopStatement);
        }
        return new Object();
    }

    @Override
    protected Object handleSwitch(Switch switchStatement) {
        if (super.containsExternalCall((Statement)switchStatement)) {
            BranchAction branchAction = SeffFactory.eINSTANCE.createBranchAction();
            this.createAbstracActionClassMethodLink((AbstractAction)branchAction, (Statement)switchStatement);
            this.seff.getSteps_Behaviour().add((Object)branchAction);
            branchAction.setEntityName(this.positionToString((Commentable)switchStatement));
            this.linkSeffElement((Identifier)branchAction, new Statement[]{switchStatement});
            List<List<Statement>> branches = SwitchStatementHelper.createBlockListFromSwitchStatement(switchStatement);
            for (List<Statement> branch : branches) {
                ProbabilisticBranchTransition bt = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
                ResourceDemandingBehaviour branchBehaviour = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
                bt.setBranchBehaviour_BranchTransition(branchBehaviour);
                this.linkSeffElement((Identifier)branchBehaviour, branch);
                StartAction startAction = SeffFactory.eINSTANCE.createStartAction();
                bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)startAction);
                this.createAbstracActionClassMethodLink((AbstractAction)startAction, (Statement)switchStatement);
                bt.setEntityName("parent " + this.positionToString((Commentable)switchStatement) + "/" + (branch.size() > 0 ? String.valueOf(this.positionToLineNumber(KDMHelper.getJavaNodeSourceRegion((Commentable)((Commentable)branch.get(0))))) + " to " + this.positionToLineNumber(KDMHelper.getJavaNodeSourceRegion((Commentable)((Commentable)branch.get(branch.size() - 1)))) : ""));
                branchAction.getBranches_Branch().add((Object)bt);
                JaMoPPStatementVisitor visitor = new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, bt.getBranchBehaviour_BranchTransition(), this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder);
                for (Statement statement : branch) {
                    List<BitSet> thisTypes = visitor.functionClassificationAnnotation.get(statement);
                    for (BitSet thisType : thisTypes) {
                        if (!visitor.shouldSkip(visitor.lastType, thisType)) {
                            visitor.doSwitch((EObject)statement);
                        }
                        visitor.lastType = thisType;
                    }
                }
                StopAction stopAction = SeffFactory.eINSTANCE.createStopAction();
                bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)stopAction);
                this.createAbstracActionClassMethodLink((AbstractAction)stopAction, (Statement)switchStatement);
                VisitorUtils.connectActions(bt.getBranchBehaviour_BranchTransition());
            }
        } else {
            this.createInternalAction((Statement)switchStatement);
        }
        return new Object();
    }

    @Override
    protected Object handleTryBlock(TryBlock tryBlock) {
        if (super.containsExternalCall((Statement)tryBlock)) {
            JaMoPPStatementVisitor visitor = new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder);
            for (Statement statement : tryBlock.getStatements()) {
                visitor.doSwitch((EObject)statement);
            }
            if (tryBlock.getFinallyBlock() != null) {
                new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder).doSwitch((EObject)tryBlock.getFinallyBlock());
            }
        } else {
            this.createInternalAction((Statement)tryBlock);
        }
        return new Object();
    }

    @Override
    protected Object handleCondition(Condition condition) {
        if (this.containsExternalCall((Statement)condition)) {
            BranchAction branch = SeffFactory.eINSTANCE.createBranchAction();
            this.createAbstracActionClassMethodLink((AbstractAction)branch, (Statement)condition);
            this.seff.getSteps_Behaviour().add((Object)branch);
            branch.setEntityName(this.positionToString((Commentable)condition));
            this.linkSeffElement((Identifier)branch, new Statement[]{condition});
            Statement ifStatement = condition.getStatement();
            this.handleIfOrElseBranch(condition, branch, ifStatement);
            Statement elseStatement = condition.getElseStatement();
            if (elseStatement != null) {
                this.handleIfOrElseBranch(condition, branch, elseStatement);
            }
        } else {
            this.createInternalAction((Statement)condition);
        }
        return new Object();
    }

    @Override
    protected Object handleClassMethod(ClassMethod classMethod, Statement callStatement) {
        if (this.resourceDemandingBehaviourForClassMethodFinding == null) {
            return this.handleStatementListContainer((StatementListContainer)classMethod);
        }
        ResourceDemandingSEFF rdBehaviour = this.resourceDemandingBehaviourForClassMethodFinding.getCorrespondingRDSEFForClassMethod(classMethod);
        if (rdBehaviour == null) {
            rdBehaviour = this.getOrCreateResourceDemandingInternalBehaviour(classMethod);
        }
        if (rdBehaviour instanceof ResourceDemandingInternalBehaviour) {
            this.createInternalCallAction((ResourceDemandingInternalBehaviour)rdBehaviour, callStatement);
        }
        this.doNotSkipNextStatement = true;
        return new Object();
    }

    private void createInternalCallAction(ResourceDemandingInternalBehaviour resourceDemandingBehavior, Statement callStatement) {
        InternalCallAction internalCallAction = SeffFactory.eINSTANCE.createInternalCallAction();
        internalCallAction.setCalledResourceDemandingInternalBehaviour(resourceDemandingBehavior);
        internalCallAction.setEntityName(this.positionToString((Commentable)callStatement));
        this.linkSeffElement((Identifier)internalCallAction, callStatement);
        if (callStatement != null) {
            this.createAbstracActionClassMethodLink((AbstractAction)internalCallAction, callStatement);
        } else {
            logger.warn((Object)"Call statement == null: can not create an AbstractActionClassMethodLink for the current InternalCallAction");
        }
        this.seff.getSteps_Behaviour().add((Object)internalCallAction);
    }

    private ResourceDemandingInternalBehaviour getOrCreateResourceDemandingInternalBehaviour(ClassMethod classMethod) {
        ResourceDemandingInternalBehaviour resourceDemandingInternalBehaviour = this.resourceDemandingBehaviourForClassMethodFinding.getCorrespondingResourceDemandingInternalBehaviour(classMethod);
        if (resourceDemandingInternalBehaviour != null) {
            return resourceDemandingInternalBehaviour;
        }
        return this.createResourceDemandingInternalBehaviour(classMethod);
    }

    private void createMethodLevelResourceDemandingInternalBehaviorLink(ClassMethod classMethod, ResourceDemandingInternalBehaviour resourceDemandingInternalBehaviour) {
        if (this.sourceCodeDecoratorRepository != null) {
            MethodLevelResourceDemandingInternalBehaviorLink methodLevelResourceDemandingInternalBehaviorLink = SourcecodedecoratorFactory.eINSTANCE.createMethodLevelResourceDemandingInternalBehaviorLink();
            methodLevelResourceDemandingInternalBehaviorLink.setFunction((Member)classMethod);
            methodLevelResourceDemandingInternalBehaviorLink.setResourceDemandingInternalBehaviour(resourceDemandingInternalBehaviour);
            this.sourceCodeDecoratorRepository.getMethodLevelResourceDemandingInternalBehaviorLink().add((Object)methodLevelResourceDemandingInternalBehaviorLink);
        }
    }

    private ResourceDemandingInternalBehaviour createResourceDemandingInternalBehaviour(ClassMethod classMethod) {
        ResourceDemandingInternalBehaviour resourceDemandingInternalBehaviour = SeffFactory.eINSTANCE.createResourceDemandingInternalBehaviour();
        this.createMethodLevelResourceDemandingInternalBehaviorLink(classMethod, resourceDemandingInternalBehaviour);
        StartAction startAction = SeffFactory.eINSTANCE.createStartAction();
        resourceDemandingInternalBehaviour.getSteps_Behaviour().add((Object)startAction);
        JaMoPPStatementVisitor methodVisitor = new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, (ResourceDemandingBehaviour)resourceDemandingInternalBehaviour, this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder);
        methodVisitor.handleStatementListContainer((StatementListContainer)classMethod);
        StopAction stopAction = SeffFactory.eINSTANCE.createStopAction();
        resourceDemandingInternalBehaviour.getSteps_Behaviour().add((Object)stopAction);
        VisitorUtils.connectActions((ResourceDemandingBehaviour)resourceDemandingInternalBehaviour);
        return resourceDemandingInternalBehaviour;
    }

    private void handleIfOrElseBranch(Condition input, BranchAction branch, Statement ifElseStatement) {
        ProbabilisticBranchTransition bt = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
        ResourceDemandingBehaviour branchBehaviour = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
        bt.setBranchBehaviour_BranchTransition(branchBehaviour);
        StartAction startAction = SeffFactory.eINSTANCE.createStartAction();
        this.createAbstracActionClassMethodLink((AbstractAction)startAction, ifElseStatement);
        bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)startAction);
        bt.setEntityName("parent " + this.positionToString((Commentable)input) + "/" + this.positionToString((Commentable)ifElseStatement));
        branch.getBranches_Branch().add((Object)bt);
        JaMoPPStatementVisitor visitor = new JaMoPPStatementVisitor((Map<Commentable, List<BitSet>>)this.functionClassificationAnnotation, bt.getBranchBehaviour_BranchTransition(), this.sourceCodeDecoratorRepository, this.primitiveComponent, this.interfaceOfExternalCallFinder, this.resourceDemandingBehaviourForClassMethodFinding, this.methodCallFinder);
        visitor.doSwitch((EObject)ifElseStatement);
        StopAction stopAction = SeffFactory.eINSTANCE.createStopAction();
        this.createAbstracActionClassMethodLink((AbstractAction)stopAction, ifElseStatement);
        bt.getBranchBehaviour_BranchTransition().getSteps_Behaviour().add((Object)stopAction);
        VisitorUtils.connectActions(bt.getBranchBehaviour_BranchTransition());
    }

    private void createExternalCallAction(Statement object, Method calledMethod, BitSet newLastType) {
        ExternalCallAction call = SeffFactory.eINSTANCE.createExternalCallAction();
        this.createAbstracActionClassMethodLink((AbstractAction)call, object);
        this.linkSeffElement((Identifier)call, object);
        call.setEntityName(String.valueOf(calledMethod.getName()) + this.positionToString((Commentable)object));
        InterfaceOfExternalCallFinding.InterfacePortOperationTuple ifOperationTuple = this.interfaceOfExternalCallFinder.getCalledInterfacePort(calledMethod);
        if (ifOperationTuple == null) {
            logger.warn((Object)"ifOperationTuple == null");
        } else {
            call.setRole_ExternalService((OperationRequiredRole)ifOperationTuple.role);
            call.setCalledService_ExternalService((OperationSignature)ifOperationTuple.signature);
        }
        this.seff.getSteps_Behaviour().add((Object)call);
        this.lastType = newLastType;
    }

    private void createInternalAction(Statement statement) {
        List thisTypes = (List)this.functionClassificationAnnotation.get(statement);
        for (BitSet thisType : thisTypes) {
            this.createInternalAction(statement, thisType);
        }
    }

    private void createInternalAction(Statement statement, BitSet thisType) {
        if (!this.shouldSkip(this.lastType, thisType) && !this.isLastTypeInternalAction()) {
            InternalAction internalAction = SeffFactory.eINSTANCE.createInternalAction();
            this.createAbstracActionClassMethodLink((AbstractAction)internalAction, statement);
            this.linkSeffElement((Identifier)internalAction, statement);
            internalAction.setEntityName("IA " + this.positionToString((Commentable)statement));
            this.seff.getSteps_Behaviour().add((Object)internalAction);
            this.lastInternalAction = internalAction;
        }
        this.linkSeffElement((Identifier)this.lastInternalAction, statement);
        this.lastType = thisType;
    }

    private boolean isLastTypeInternalAction() {
        EList steps = this.seff.getSteps_Behaviour();
        return !steps.isEmpty() && steps.get(steps.size() - 1) instanceof InternalAction;
    }

    private void createAbstracActionClassMethodLink(AbstractAction abstractAction, Statement statement) {
        ClassMethod classMethod = this.getClassMethodFromCommentable((Commentable)statement);
        if (classMethod == null) {
            logger.warn((Object)("Could not create AbstracActionClassMethodLink for AbstractAction " + abstractAction + " and Statement " + statement));
            return;
        }
        AbstractActionClassMethodLink abstractActionClassMethodLink = SourcecodedecoratorFactory.eINSTANCE.createAbstractActionClassMethodLink();
        abstractActionClassMethodLink.setAbstractAction(abstractAction);
        abstractActionClassMethodLink.setClassMethod(classMethod);
        if (this.sourceCodeDecoratorRepository != null) {
            this.sourceCodeDecoratorRepository.getAbstractActionClassMethodLink().add((Object)abstractActionClassMethodLink);
        }
    }

    private ClassMethod getClassMethodFromCommentable(Commentable statement) {
        if (statement.eContainer() instanceof ClassMethod) {
            return (ClassMethod)statement.eContainer();
        }
        if (statement.eContainer() instanceof Commentable) {
            return this.getClassMethodFromCommentable((Commentable)statement.eContainer());
        }
        logger.warn((Object)("Could not found method for Commentable: " + statement));
        return null;
    }

    private void linkSeffElement(Identifier seffElement, Statement ... statements) {
        this.linkSeffElement(seffElement, Arrays.asList(statements));
    }

    private void linkSeffElement(Identifier seffElement, List<Statement> statements) {
        SeffElementSourceCodeLink link;
        if (this.sourceCodeDecoratorRepository == null) {
            return;
        }
        if (this.seffElemestSourceCodeLinks.containsKey(seffElement)) {
            link = this.seffElemestSourceCodeLinks.get(seffElement);
        } else {
            link = SourcecodedecoratorFactory.eINSTANCE.createSeffElementSourceCodeLink();
            link.setSeffElement(seffElement);
            this.seffElemestSourceCodeLinks.put(seffElement, link);
            this.sourceCodeDecoratorRepository.getSeffElementsSourceCodeLinks().add((Object)link);
        }
        link.getStatement().addAll(statements);
    }

    @Override
    protected void foundInternalAction(Statement statement) {
        this.createInternalAction(statement);
    }

    @Override
    protected void foundExternalCall(Statement object, Method calledMethod, BitSet statementAnnotation) {
        this.createExternalCallAction(object, calledMethod, statementAnnotation);
    }

    @Override
    protected void foundEmitEventAction(Statement statement, Method calledMethod, BitSet statementAnnotation) {
        EmitEventAction emitEventAction = SeffFactory.eINSTANCE.createEmitEventAction();
        this.createAbstracActionClassMethodLink((AbstractAction)emitEventAction, statement);
        this.linkSeffElement((Identifier)emitEventAction, statement);
        emitEventAction.setEntityName(String.valueOf(calledMethod.getName()) + this.positionToString((Commentable)statement));
        InterfaceOfExternalCallFinding.InterfacePortOperationTuple ifOperationTuple = this.interfaceOfExternalCallFinder.getCalledInterfacePort(calledMethod, statement);
        if (ifOperationTuple == null) {
            logger.warn((Object)"ifOperationTuple == null");
        } else {
            emitEventAction.setSourceRole__EmitEventAction((SourceRole)ifOperationTuple.role);
            emitEventAction.setEventType__EmitEventAction((EventType)ifOperationTuple.signature);
        }
        this.seff.getSteps_Behaviour().add((Object)emitEventAction);
        this.lastType = statementAnnotation;
    }

    @Override
    protected Object handleSynchronizedBlock(SynchronizedBlock synchronizedBlock) {
        PassiveResource passiveResource = RepositoryFactory.eINSTANCE.createPassiveResource();
        passiveResource.setEntityName(this.positionToString((Commentable)KDMHelper.getJavaNodeSourceRegion((Commentable)synchronizedBlock)));
        passiveResource.setCapacity_PassiveResource(CoreFactory.eINSTANCE.createPCMRandomVariable());
        this.primitiveComponent.getPassiveResource_BasicComponent().add((Object)passiveResource);
        passiveResource.getCapacity_PassiveResource().setSpecification("1");
        logger.debug((Object)"start handling synchronized statement");
        AcquireAction acquireAction = SeffFactory.eINSTANCE.createAcquireAction();
        logger.debug((Object)"create acquireAction");
        this.seff.getSteps_Behaviour().add((Object)acquireAction);
        acquireAction.setPassiveresource_AcquireAction(passiveResource);
        acquireAction.setEntityName(this.positionToString((Commentable)KDMHelper.getJavaNodeSourceRegion((Commentable)synchronizedBlock)));
        Object ret = this.handleStatementListContainer((StatementListContainer)synchronizedBlock);
        logger.debug((Object)"create releaseAction");
        ReleaseAction releaseAction = SeffFactory.eINSTANCE.createReleaseAction();
        this.seff.getSteps_Behaviour().add((Object)releaseAction);
        releaseAction.setPassiveResource_ReleaseAction(passiveResource);
        releaseAction.setEntityName(this.positionToString((Commentable)KDMHelper.getJavaNodeSourceRegion((Commentable)synchronizedBlock)));
        return ret;
    }
}

