/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.statements.Break;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SwitchCase;

public class SwitchStatementHelper {
    private static final Logger logger = Logger.getLogger((String)SwitchStatementHelper.class.getSimpleName());

    public static List<List<Statement>> createBlockListFromSwitchStatement(Switch switchStatement) {
        ArrayList<List<Statement>> blockList = new ArrayList<List<Statement>>();
        for (SwitchCase switchCase : switchStatement.getCases()) {
            List<Statement> currentBlock = SwitchStatementHelper.findNextBlock(switchCase, switchStatement);
            blockList.add(currentBlock);
        }
        return blockList;
    }

    private static List<Statement> findNextBlock(SwitchCase switchCase, Switch switchStatement) {
        if (SwitchStatementHelper.endsWithBreakStatement(switchCase) || SwitchStatementHelper.isLastBlock(switchCase, (EList<SwitchCase>)switchStatement.getCases())) {
            return switchCase.getStatements();
        }
        ArrayList<Statement> currentBlock = new ArrayList<Statement>(switchCase.getStatements().size() * 4);
        currentBlock.addAll((Collection<Statement>)switchCase.getStatements());
        int nextIndex = switchStatement.getCases().indexOf((Object)switchCase) + 1;
        SwitchCase nextSwitchCase = (SwitchCase)switchStatement.getCases().get(nextIndex);
        List<Statement> nextBlock = SwitchStatementHelper.findNextBlock(nextSwitchCase, switchStatement);
        currentBlock.addAll(nextBlock);
        return currentBlock;
    }

    private static boolean isLastBlock(SwitchCase switchCase, EList<SwitchCase> cases) {
        return cases.indexOf((Object)switchCase) == cases.size() - 1;
    }

    private static boolean endsWithBreakStatement(SwitchCase switchCase) {
        if (switchCase.getStatements().isEmpty()) {
            return false;
        }
        Statement lastStatement = (Statement)switchCase.getStatements().get(switchCase.getStatements().size() - 1);
        if (lastStatement instanceof Break) {
            return true;
        }
        EList breaks = switchCase.getChildrenByType(Break.class);
        if (breaks.size() > 0) {
            logger.warn((Object)("Break found in switch case statement " + switchCase + " - it is, however, not the last statement in the switch case."));
            return true;
        }
        return false;
    }
}

