/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.somox.kdmhelper.EqualityChecker;
import org.somox.kdmhelper.GetAccessedType;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.modifiers.Final;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.Private;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.Boolean;
import tools.mdsd.jamopp.model.java.types.Byte;
import tools.mdsd.jamopp.model.java.types.Char;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Double;
import tools.mdsd.jamopp.model.java.types.Float;
import tools.mdsd.jamopp.model.java.types.Int;
import tools.mdsd.jamopp.model.java.types.Long;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Short;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.Void;

public class KDMHelper {
    private static boolean SISSYMODE = false;

    public static String getName(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof NamedElement) {
            return ((NamedElement)type).getName();
        }
        if (type instanceof Classifier) {
            return ((Classifier)type).getName();
        }
        if (type instanceof Package) {
            return ((Package)type).getName();
        }
        if (type instanceof CompilationUnit) {
            return ((CompilationUnit)type).getName();
        }
        if (type instanceof Method) {
            return ((Method)type).getName();
        }
        if (type instanceof Parameter) {
            return ((Parameter)type).getName();
        }
        if (type instanceof Member) {
            return ((Member)type).getName();
        }
        if (type instanceof Interface) {
            return ((Interface)type).getName();
        }
        if (type instanceof PrimitiveType) {
            return KDMHelper.getName((PrimitiveType)type);
        }
        return type.toString();
    }

    public static String getName(PrimitiveType type) {
        if (type instanceof Boolean) {
            return "bool";
        }
        if (type instanceof Byte) {
            return "byte";
        }
        if (type instanceof Char) {
            return "char";
        }
        if (type instanceof Double) {
            return "double";
        }
        if (type instanceof Float) {
            return "float";
        }
        if (type instanceof Int) {
            return "int";
        }
        if (type instanceof Long) {
            return "long";
        }
        if (type instanceof Short) {
            return "short";
        }
        if (type instanceof Void) {
            return "void";
        }
        return type.toString();
    }

    public static String computeFullQualifiedName(Commentable astClass) {
        Commentable pack = astClass;
        String result = "";
        if (pack instanceof NamedElement) {
            result = KDMHelper.getNameOfNamedElement((NamedElement)pack);
        }
        while (pack != null) {
            if (pack.eContainer() != null && pack.eContainer() instanceof NamedElement) {
                pack = pack.eContainer();
                result = String.valueOf(KDMHelper.getNameOfNamedElement((NamedElement)pack)) + "." + result;
                continue;
            }
            pack = pack.eContainer();
        }
        return KDMHelper.removeLastPoint(result);
    }

    public static Method getMethod(MethodCall methodCall) {
        ReferenceableElement re = methodCall.getTarget();
        if (re instanceof Method) {
            return (Method)re;
        }
        return null;
    }

    public static String removeLastPoint(String result) {
        if (result != null && result.endsWith(".")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String getNameOfNamedElement(NamedElement input) {
        String result = "";
        result = input instanceof Method ? String.valueOf(input.getName()) + "()" : input.getName();
        return result;
    }

    private static Set<Type> getAccessedTypes(Commentable element) {
        HashSet<Type> result = new HashSet<Type>();
        Type accessedType = GetAccessedType.getAccessedType(element);
        if (SISSYMODE) {
            if (accessedType != null) {
                result.add(accessedType);
            }
        } else if (accessedType instanceof VariableLengthParameter) {
            Parameter paramType = (Parameter)accessedType;
            result.add(paramType.getTypeReference().getTarget());
            for (TypeArgument typeAccess : paramType.getTypeArguments()) {
                if (((TypeReference)typeAccess).getTarget() instanceof Parameter) {
                    result.addAll(KDMHelper.getAccessedTypes((Commentable)typeAccess));
                    continue;
                }
                result.add(GetAccessedType.getAccessedType((Commentable)typeAccess));
            }
        } else {
            result.add(accessedType);
        }
        return result;
    }

    public static List<Type> getAllAccessedClasses(Type input) {
        HashSet<Type> resultList = new HashSet<Type>();
        List<TypeReference> accesses = KDMHelper.getAllAccesses((Commentable)input);
        for (Commentable commentable : accesses) {
            resultList.addAll(KDMHelper.getAccessedTypes(commentable));
        }
        return new ArrayList<Type>(resultList);
    }

    public static List<TypeReference> getAllAccesses(Commentable input) {
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        TreeIterator iterator = input.eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof TypeReference) || !KDMHelper.isAccess((Commentable)((TypeReference)element))) continue;
            result.add((TypeReference)element);
        }
        return result;
    }

    public static List<ConcreteClassifier> getInnerClasses(ConcreteClassifier clazz) {
        ArrayList<ConcreteClassifier> result = new ArrayList<ConcreteClassifier>();
        if (!(clazz instanceof tools.mdsd.jamopp.model.java.classifiers.Class)) {
            return result;
        }
        TreeIterator iterator = clazz.eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof tools.mdsd.jamopp.model.java.classifiers.Class) || !KDMHelper.isInnerClass((ConcreteClassifier)element)) continue;
            result.add((ConcreteClassifier)((tools.mdsd.jamopp.model.java.classifiers.Class)element));
        }
        return result;
    }

    public static CompilationUnit getJavaNodeSourceRegion(Commentable node) {
        return node.getContainingCompilationUnit();
    }

    public static List<Method> getMethods(ConcreteClassifier input) {
        return input.getMethods();
    }

    public static Method getOverriddenASTNode(Method methDecInput) {
        ConcreteClassifier classifierOfMethod = methDecInput.getContainingConcreteClassifier();
        List<ConcreteClassifier> superTypes = KDMHelper.getSuperTypes(classifierOfMethod);
        for (ConcreteClassifier concreteClassifier : superTypes) {
            List<Method> method = KDMHelper.getMethods(concreteClassifier);
            for (Method methodDeclaration : method) {
                if (!EqualityChecker.areFunctionsEqual(methDecInput, methodDeclaration)) continue;
                return methodDeclaration;
            }
        }
        return null;
    }

    public static String getSISSyID(Commentable node) {
        return node.toString();
    }

    public static List<ConcreteClassifier> getSuperTypes(ConcreteClassifier concreteClassifier) {
        if (concreteClassifier == null) {
            return Collections.emptyList();
        }
        return concreteClassifier.getAllSuperClassifiers();
    }

    public static Package getSurroundingPackage(Type input) {
        return null;
    }

    public static boolean isAbstract(AnnotableAndModifiable input) {
        return input.getModifiers().contains((Object)ModifiersFactory.eINSTANCE.createAbstract());
    }

    public static boolean isAccess(Commentable element) {
        return element instanceof MethodCall || element instanceof ClassifierReference || element instanceof IdentifierReference;
    }

    public static boolean isInheritanceTypeAccess(TypeReference inputTypeAccess) {
        if (inputTypeAccess.eContainer() instanceof ConcreteClassifier) {
            ConcreteClassifier concreteClassifier = (ConcreteClassifier)inputTypeAccess.eContainer();
            for (TypeReference typeReference : KDMHelper.getInheritanceTypeAccesses(concreteClassifier)) {
                if (typeReference != inputTypeAccess) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ClassifierReference> getInheritanceTypeAccesses(ConcreteClassifier concreteClassifier) {
        return concreteClassifier.getSuperTypeReferences();
    }

    public static boolean isInnerClass(ConcreteClassifier clazz) {
        return clazz.eContainer() instanceof tools.mdsd.jamopp.model.java.classifiers.Class;
    }

    public static EClass[] getNewEClassEnumeration() {
        return null;
    }

    public static boolean isInterface(Commentable input) {
        return input instanceof Interface;
    }

    public static boolean isPrimitive(Type input) {
        return input instanceof PrimitiveType;
    }

    public static boolean isVirtual(Method method) {
        if (method == null || method.getModifiers() == null) {
            return false;
        }
        for (Modifier modifier : method.getModifiers()) {
            if (!(modifier instanceof Private) && !(modifier instanceof Static) && !(modifier instanceof Final)) continue;
            return false;
        }
        return true;
    }

    public static StatementListContainer getBody(Member member) {
        if (member instanceof StatementListContainer) {
            return (StatementListContainer)member;
        }
        return StatementsFactory.eINSTANCE.createBlock();
    }

    public static EList<Package> getOwnedPackages(Package prefixPackage) {
        return null;
    }

    public static Object getPackage(Package element) {
        return null;
    }

    public static Collection<Package> getOwnedElements(Package element) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Constructor> getConstructors(Type implementingClass) {
        void var3_2;
        ConcreteClassifier concreteClassifier;
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        Type type = implementingClass;
        if (type instanceof ConcreteClassifier && (concreteClassifier = (ConcreteClassifier)type) == (ConcreteClassifier)var3_2) {
            void concreteClassifier2;
            for (Member member : concreteClassifier2.getMembers()) {
                if (!(member instanceof Constructor)) continue;
                constructors.add((Constructor)member);
            }
        }
        return constructors;
    }

    public static <T> T getFirstChildWithType(Commentable commentable, Class<T> classType) {
        EList children = commentable.getChildrenByType(classType);
        if (children != null && children.size() > 0) {
            return (T)children.get(0);
        }
        return null;
    }
}

