/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.somox.kdmhelper.EqualityChecker;
import org.somox.kdmhelper.KDMHelper;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;

public class SoMoXUtil {
    private SoMoXUtil() {
    }

    public static boolean isStandalone() {
        try {
            ResourcesPlugin.getWorkspace();
        }
        catch (IllegalStateException illegalStateException) {
            return true;
        }
        return false;
    }

    public static Collection<StatementListContainer> findImplementingMethods(InterfaceMethod interfaceMethod, Collection<ConcreteClassifier> implementingClasses) {
        ConcreteClassifier interfaceOfMethod = interfaceMethod.getContainingConcreteClassifier();
        HashSet<StatementListContainer> implementingStatementListContainers = new HashSet<StatementListContainer>();
        if (implementingClasses != null) {
            for (ConcreteClassifier classInComponent : implementingClasses) {
                if (!KDMHelper.getSuperTypes(classInComponent).contains(interfaceOfMethod)) continue;
                for (Method methodInClass : classInComponent.getMethods()) {
                    if (!EqualityChecker.areFunctionsEqual((Method)interfaceMethod, methodInClass) || !(methodInClass instanceof ClassMethod)) continue;
                    implementingStatementListContainers.add(KDMHelper.getBody((Member)methodInClass));
                }
            }
        }
        return implementingStatementListContainers;
    }
}

