/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.Parametrizable;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class EqualityChecker {
    public static boolean areFunctionsEqual(Method function1, Method function2) {
        if (function1 == function2) {
            return true;
        }
        if (!EqualityChecker.checkNameEqual((NamedElement)function1, (NamedElement)function2)) {
            return false;
        }
        if (EqualityChecker.getReturnTypeAccess(function1) == null || EqualityChecker.getReturnTypeAccess(function2) == null || function1.getParameters() == null || function2.getParameters() == null) {
            return false;
        }
        return EqualityChecker.targetInTypeReferenceEquals(EqualityChecker.getReturnTypeAccess(function1), EqualityChecker.getReturnTypeAccess(function2)) && EqualityChecker.checkParametersEqual((Parametrizable)function1, (Parametrizable)function2);
    }

    private static boolean checkNameEqual(NamedElement namedElement1, NamedElement namedElement2) {
        return namedElement1.getName().equals(namedElement2.getName());
    }

    private static boolean checkParametersEqual(Parametrizable function1, Parametrizable function2) {
        if (function1.getParameters() != null && function2.getParameters() != null && function1.getParameters().size() != function2.getParameters().size()) {
            return false;
        }
        int i = 0;
        while (i < function1.getParameters().size()) {
            if (!EqualityChecker.targetInTypeReferenceEquals(((Parameter)function1.getParameters().get(i)).getTypeReference(), ((Parameter)function2.getParameters().get(i)).getTypeReference())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areConstructorsEqual(Constructor constructor1, Constructor constructor2) {
        if (constructor1 == constructor2) {
            return true;
        }
        return EqualityChecker.checkNameEqual((NamedElement)constructor1, (NamedElement)constructor2) && EqualityChecker.checkParametersEqual((Parametrizable)constructor1, (Parametrizable)constructor2);
    }

    private static boolean targetInTypeReferenceEquals(TypeReference typeRef1, TypeReference typeRef2) {
        if (typeRef1.getTarget() == null && typeRef2.getTarget() == null) {
            return true;
        }
        return typeRef1.getTarget() != null && typeRef2.getTarget() != null && EqualityChecker.typeEquals(typeRef1.getTarget(), typeRef2.getTarget());
    }

    private static boolean typeEquals(Type type1, Type type2) {
        if (type1 == type2) {
            return true;
        }
        boolean sameType = type1.getClass().equals(type2.getClass());
        if (!sameType) {
            return false;
        }
        if (type1 instanceof PrimitiveType && type2 instanceof PrimitiveType) {
            return true;
        }
        if (type1 instanceof NamedElement var3_4 && ( instanceOfPatternExpressionValue = type2) instanceof NamedElement var4_6) {
            return ne1.getName().equals(ne2.getName());
        }
        return false;
    }

    private static TypeReference getReturnTypeAccess(Method function) {
        if (function instanceof Method) {
            Method method = function;
            return method.getTypeReference();
        }
        return null;
    }
}

