/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.abstractmetrics;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractComposedMetric;

public abstract class AbstractRatioMetric
extends AbstractComposedMetric
implements IMetric {
    private final ICompositionFunction ratioFunction = metricValues -> {
        double denominator = (Double)metricValues.get(this.getDenominatorMetricID());
        if (denominator == 0.0) {
            return 0.0;
        }
        return (Double)metricValues.get(this.getNumeratorMetricID()) / denominator;
    };

    @Override
    protected IMetric[] getChildMetrics(Map<MetricID, IMetric> allMetrics) {
        return new IMetric[]{this.getMetric(allMetrics, this.getNumeratorMetricID()), this.getMetric(allMetrics, this.getDenominatorMetricID())};
    }

    protected abstract MetricID getNumeratorMetricID();

    protected abstract MetricID getDenominatorMetricID();

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.ratioFunction;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        boolean result = true;
        IMetric[] iMetricArray = this.getAllChildMetrics();
        int n = iMetricArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetric childMetric = iMetricArray[n2];
            if (!childMetric.isCommutative()) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }
}

