/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.abstractmetrics;

import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.abstractmetrics.AbstractComposedMetric;

public abstract class AbstractWeightedComposedMetric
extends AbstractComposedMetric {
    private final double[] weights = this.getWeigths();
    private final ICompositionFunction function = metricValues -> {
        double weightSum = 0.0;
        double weightedSum = 0.0;
        int i = 0;
        while (i < this.weights.length) {
            double metricValue = (Double)metricValues.get(this.getAllChildMetrics()[i]);
            double weight = this.weights[i];
            weightSum += weight;
            weightedSum += metricValue * weight;
            ++i;
        }
        return weightedSum / weightSum;
    };

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.function;
    }

    protected abstract double[] getWeigths();

    @Override
    public boolean isNormalised() {
        return true;
    }
}

