/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractMetric;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.structure.SliceLayerArchitectureQuality;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.types.Type;

public class SubsystemComponent
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SubsystemComponent");
    private IMetric sliceArchitectureMetric = null;

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.sliceArchitectureMetric = this.getMetric(allMetrics, SliceLayerArchitectureQuality.METRIC_ID);
    }

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<ConcreteClassifier> classes2;
        Set<ConcreteClassifier> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        EList slices = prefixPackage.getChildrenByType(Package.class);
        EList layers = null;
        String subLayer = null;
        int max = 0;
        for (Package current : slices) {
            if (current.getChildrenByType(Package.class).size() < max) continue;
            layers = current.getChildrenByType(Package.class);
            max = layers.size();
        }
        if (max == 0 || layers.size() == 0 || layers == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        Package currentPackage = null;
        Iterator<ConcreteClassifier> iterator = classes1.iterator();
        block1: while (iterator.hasNext()) {
            Type cfr_ignored_0 = (Type)iterator.next();
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!KDMHelper.computeFullQualifiedName((Commentable)currentPackage).startsWith(KDMHelper.computeFullQualifiedName((Commentable)slicePackage))) continue;
                    for (Package layerPackage : layers) {
                        if (!KDMHelper.computeFullQualifiedName((Commentable)currentPackage).startsWith(String.valueOf(KDMHelper.computeFullQualifiedName((Commentable)slicePackage)) + "." + layerPackage.getName())) continue;
                        subLayer = String.valueOf(KDMHelper.computeFullQualifiedName((Commentable)slicePackage)) + "." + layerPackage.getName();
                        continue block1;
                    }
                    continue block1;
                }
                continue;
            }
            if (KDMHelper.computeFullQualifiedName(currentPackage).startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        block4: for (Type type : classes2) {
            currentPackage = KDMHelper.getSurroundingPackage((Type)type);
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!KDMHelper.computeFullQualifiedName((Commentable)currentPackage).startsWith(KDMHelper.computeFullQualifiedName((Commentable)slicePackage))) continue;
                    for (Package layerPackage : layers) {
                        if (!KDMHelper.computeFullQualifiedName((Commentable)currentPackage).startsWith(String.valueOf(KDMHelper.computeFullQualifiedName((Commentable)slicePackage)) + "." + layerPackage.getName())) continue;
                        subLayer = String.valueOf(KDMHelper.computeFullQualifiedName((Commentable)slicePackage)) + "." + layerPackage.getName();
                        continue block4;
                    }
                    continue block4;
                }
                continue;
            }
            if (KDMHelper.computeFullQualifiedName((Commentable)currentPackage).startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        this.sliceArchitectureMetric.computeDirected(relationToCompute);
        assert (relationToCompute.getResult().containsKey(this.sliceArchitectureMetric.getMID()));
        double d = relationToCompute.getResult().get(this.sliceArchitectureMetric.getMID());
        relationToCompute.setResultMetric(this.getMID(), d);
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Package computePrefix(Set<ConcreteClassifier> elements1, Set<ConcreteClassifier> elements2) {
        Package prefix = null;
        LinkedList<ConcreteClassifier> elementsLeft = new LinkedList<ConcreteClassifier>();
        elementsLeft.addAll(elements1);
        elementsLeft.addAll(elements2);
        ListIterator iterator = elementsLeft.listIterator();
        while (iterator.hasNext()) {
            Type current = (Type)iterator.next();
            if (prefix == null && KDMHelper.getSurroundingPackage((Type)current) != null) {
                prefix = KDMHelper.getSurroundingPackage((Type)current);
            }
            if (prefix == null || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((Commentable)current).startsWith(KDMHelper.computeFullQualifiedName((Commentable)prefix))) continue;
            if (prefix == null) {
                return null;
            }
            iterator = elementsLeft.listIterator();
        }
        return prefix;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

