/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.naming;

public class JaroWinkler {
    private static String commonChars(String s, String t, int half) {
        StringBuilder common = new StringBuilder();
        StringBuilder copy = new StringBuilder(t);
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            boolean foundIt = false;
            int j = Math.max(0, i - half);
            while (!foundIt && j < Math.min(i + half + 1, t.length())) {
                if (copy.charAt(j) == ch) {
                    foundIt = true;
                    common.append(ch);
                    copy.setCharAt(j, '*');
                }
                ++j;
            }
            ++i;
        }
        return common.toString();
    }

    private static int commonPrefixLength(int max, String s, String t) {
        int n = Math.min(max, Math.min(s.length(), t.length()));
        int i = 0;
        while (i < n) {
            if (s.charAt(i) != t.charAt(i)) {
                return i;
            }
            ++i;
        }
        return n;
    }

    public static double distance(String s, String t) {
        double distance = JaroWinkler.innerDistance(s, t);
        int prefixLength = JaroWinkler.commonPrefixLength(4, s, t);
        return distance + (double)prefixLength * 0.1 * (1.0 - distance);
    }

    private static int getHalf(String s, String t) {
        return s.length() > t.length() ? t.length() / 2 + 1 : s.length() / 2 + 1;
    }

    private static double innerDistance(String s, String t) {
        int halflen = JaroWinkler.getHalf(s, t);
        String commonS = JaroWinkler.commonChars(s, t, halflen);
        String commonT = JaroWinkler.commonChars(t, s, halflen);
        if (commonS.length() != commonT.length() || commonS.length() == 0 || commonT.length() == 0) {
            return 0.0;
        }
        int transpositions = JaroWinkler.transpositions(commonS, commonT);
        return ((double)commonS.length() / (double)s.length() + (double)commonT.length() / (double)t.length() + (double)(commonS.length() - transpositions) / (double)commonS.length()) / 3.0;
    }

    private static int transpositions(String s, String t) {
        int transpositions = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != t.charAt(i)) {
                ++transpositions;
            }
            ++i;
        }
        return transpositions /= 2;
    }
}

