/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractMetric;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.types.Type;

public class SliceLayerArchitectureQuality
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SliceLayerArchitectureQuality");

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<ConcreteClassifier> classes2;
        Set<ConcreteClassifier> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        EList slices = KDMHelper.getOwnedPackages((Package)prefixPackage);
        EList layers = null;
        int max = 0;
        for (Package current : slices) {
            if (KDMHelper.getOwnedPackages((Package)current).size() < max) continue;
            layers = KDMHelper.getOwnedPackages((Package)current);
            max = layers.size();
        }
        if (max == 0) {
            relationToCompute.setResultMetric(this.getMID(), 1.0);
        } else {
            int expectedSubsystems = slices.size() * layers.size();
            int existingSubsystems = 0;
            for (Package currentSlice : slices) {
                EList currentLayers = KDMHelper.getOwnedPackages((Package)currentSlice);
                block2: for (Package currentReferencePackage : layers) {
                    for (Package currentLayer : currentLayers) {
                        if (!currentLayer.getName().equals(currentReferencePackage.getName())) continue;
                        ++existingSubsystems;
                        continue block2;
                    }
                }
            }
            if (expectedSubsystems == 0) {
                relationToCompute.setResultMetric(this.getMID(), 1.0);
            } else {
                relationToCompute.setResultMetric(this.getMID(), (double)existingSubsystems / (double)expectedSubsystems);
            }
        }
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    /*
     * WARNING - void declaration
     */
    private Package computePrefix(Set<ConcreteClassifier> elements1, Set<ConcreteClassifier> elements2) {
        boolean prefixFound = false;
        Package currentPackage = null;
        for (Type type : elements1) {
            if (KDMHelper.getSurroundingPackage((Type)type) == null) continue;
            currentPackage = KDMHelper.getSurroundingPackage((Type)type);
            break;
        }
        if (currentPackage == null) {
            for (Type type : elements2) {
                if (KDMHelper.getSurroundingPackage((Type)type) == null) continue;
                currentPackage = KDMHelper.getSurroundingPackage((Type)type);
                break;
            }
        }
        if (currentPackage == null) {
            return null;
        }
        String string = KDMHelper.computeFullQualifiedName(currentPackage);
        while (!prefixFound) {
            prefixFound = true;
            for (ConcreteClassifier current : elements1) {
                void var5_10;
                if (KDMHelper.isInnerClass((ConcreteClassifier)current) || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((Commentable)KDMHelper.getSurroundingPackage((Type)current)).contains((CharSequence)var5_10)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if (currentPackage == null) {
                return null;
            }
            String string2 = KDMHelper.computeFullQualifiedName((Commentable)currentPackage);
        }
        prefixFound = false;
        while (!prefixFound) {
            prefixFound = true;
            for (ConcreteClassifier current : elements2) {
                void var5_12;
                if (KDMHelper.isInnerClass((ConcreteClassifier)current) || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((Commentable)KDMHelper.getSurroundingPackage((Type)current)).contains((CharSequence)var5_12)) continue;
                prefixFound = false;
                break;
            }
            if (prefixFound) continue;
            if (currentPackage == null) {
                return null;
            }
            String string3 = KDMHelper.computeFullQualifiedName((Commentable)currentPackage);
        }
        return currentPackage;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

