/**
 */
package tools.descartes.dlim.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Trend;

/**
 * This is the item provider adapter for a {@link tools.descartes.dlim.Trend} object.
 * <!-- begin-user-doc --> <!-- end-user-doc -->
 * @generated
 */
public class TrendItemProvider extends FunctionItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TrendItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);

            addFunctionOutputAtStartPropertyDescriptor(object);
            addFunctionOutputAtEndPropertyDescriptor(object);
        }
        return itemPropertyDescriptors;
    }

	/**
     * This adds a property descriptor for the Function Output At Start feature.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
	protected void addFunctionOutputAtStartPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Trend_functionOutputAtStart_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Trend_functionOutputAtStart_feature", "_UI_Trend_type"),
                 DlimPackage.Literals.TREND__FUNCTION_OUTPUT_AT_START,
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.REAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This adds a property descriptor for the Function Output At End feature.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
	protected void addFunctionOutputAtEndPropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (createItemPropertyDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_Trend_functionOutputAtEnd_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_Trend_functionOutputAtEnd_feature", "_UI_Trend_type"),
                 DlimPackage.Literals.TREND__FUNCTION_OUTPUT_AT_END,
                 true,
                 false,
                 false,
                 ItemPropertyDescriptor.REAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
     * This returns the label text for the adapted class.
     * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getText(Object object) {
        Trend trend = (Trend)object;
        return getString("_UI_Trend_type") + " " + trend.getFunctionOutputAtStart();
    }

	/**
     * This handles model notifications by calling {@link #updateChildren} to update any cached
     * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
     * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
     * @generated
     */
	@Override
	public void notifyChanged(Notification notification) {
        updateChildren(notification);

        switch (notification.getFeatureID(Trend.class)) {
            case DlimPackage.TREND__FUNCTION_OUTPUT_AT_START:
            case DlimPackage.TREND__FUNCTION_OUTPUT_AT_END:
                fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
        }
        super.notifyChanged(notification);
    }

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

}
