/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import java.io.IOException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.generator.editor.popup.actions.CalibrationAction;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;
import tools.descartes.dlim.reader.ArrivalRateReader;

public class LaunchCalibrationDialog
extends TitleAreaDialog {
    private static final String LASTFILEPATH_STORE_ID = "dlim.calibrationdialogfilepath";
    private CalibrationAction calibrationAction;
    private Text desiredValueText;
    private Text timeText;
    private Text txtFilePathText;
    private double newValue = 0.0;
    private static double offset = 0.0;
    private double defaultTime = 0.0;
    private boolean canceled = false;
    private String titleString;

    public LaunchCalibrationDialog(String titleString, double defaultTime, Shell parentShell, CalibrationAction calibrationAction) {
        super(parentShell);
        this.titleString = titleString;
        this.defaultTime = defaultTime;
        this.calibrationAction = calibrationAction;
    }

    public void create() {
        super.create();
        this.setTitle(this.titleString);
        this.setMessage("Calibration can only occur at times, at which the model element is actually executed.", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createDesiredValueParameterField(columnContainer);
        Label delimiterLabel = new Label(columnContainer, 0);
        delimiterLabel.setText("  or");
        this.createTxtFilePathField(columnContainer);
        this.createReadTimeField(columnContainer);
        return dialogContainer;
    }

    private void createTxtFilePathField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Arrival Rate File: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.txtFilePathText = new Text(gridContainer, 2048);
        this.txtFilePathText.setText(ProjectManager.retrieveStringFromPreferences(LASTFILEPATH_STORE_ID));
        this.txtFilePathText.setLayoutData((Object)parameterFieldData);
        Button fileDialogButton = new Button(gridContainer, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LaunchCalibrationDialog.this.getParentShell(), 4096);
                String[] filterNames = new String[]{"Arrival Rate files", "All Files"};
                String[] filterExtensions = new String[]{"*.csv;*.txt", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Select Arrival Rate File");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    LaunchCalibrationDialog.this.txtFilePathText.setText(newPath);
                }
            }
        });
    }

    private void createReadTimeField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("              Time of arrival rate value: ");
        parameterFieldLabel.setAlignment(131072);
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 0x1000008;
        parameterFieldData.widthHint = 22;
        this.timeText = new Text(gridContainer, 2048);
        this.timeText.setText(String.valueOf(this.defaultTime + offset));
        this.timeText.setLayoutData((Object)parameterFieldData);
        Button resetButton = new Button(gridContainer, 8);
        resetButton.setText("Reset time");
        resetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                offset = 0.0;
                LaunchCalibrationDialog.this.timeText.setText(String.valueOf(LaunchCalibrationDialog.this.defaultTime + offset));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                offset = 0.0;
                LaunchCalibrationDialog.this.timeText.setText(String.valueOf(LaunchCalibrationDialog.this.defaultTime + offset));
            }
        });
    }

    private void createDesiredValueParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Desired Value: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 32;
        this.desiredValueText = new Text(gridContainer, 2048);
        this.desiredValueText.setText("");
        this.desiredValueText.setLayoutData((Object)parameterFieldData);
        this.desiredValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!LaunchCalibrationDialog.this.desiredValueText.getText().equals("")) {
                    LaunchCalibrationDialog.this.txtFilePathText.setEnabled(false);
                    LaunchCalibrationDialog.this.timeText.setEnabled(false);
                } else {
                    LaunchCalibrationDialog.this.txtFilePathText.setEnabled(true);
                    LaunchCalibrationDialog.this.timeText.setEnabled(true);
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Calibration Parameters");
    }

    protected void cancelPressed() {
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        double desiredValue = 0.0;
        String desiredValueString = this.desiredValueText.getText();
        String tmpFilePath = this.txtFilePathText.getText().trim();
        Path filePath = new Path(tmpFilePath);
        double currentTime = this.defaultTime + offset;
        if (!desiredValueString.equals("")) {
            try {
                desiredValue = Double.parseDouble(desiredValueString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Desired Value must be a number.", 3);
                error = true;
            }
        } else {
            try {
                currentTime = Double.parseDouble(this.timeText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Time of arrival rate must be a number.", 3);
                error = true;
            }
            try {
                if (!error) {
                    desiredValue = ArrivalRateReader.getArrivalRateAtTimeFromFile((double)currentTime, (String)filePath.toString());
                }
            }
            catch (IOException iOException) {
                this.setMessage("Error reading file. Does it exist?", 3);
                error = true;
            }
        }
        if (!error) {
            try {
                this.newValue = this.calibrationAction.executeCalibration(desiredValue);
            }
            catch (CalibrationException e) {
                error = true;
                this.setMessage(e.getMessage(), 3);
            }
        }
        if (!error) {
            if (desiredValueString.equals("")) {
                ProjectManager.saveStringToPreferences(LASTFILEPATH_STORE_ID, tmpFilePath);
                offset = currentTime - this.defaultTime;
            }
            super.okPressed();
        }
    }

    public double getNewValue() {
        return this.newValue;
    }
}

