/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.popup.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.extractorHandler.ExtractorHandler;
import tools.descartes.dlim.generator.editor.dialogs.SelectExtractorDialog;
import tools.descartes.dlim.generator.ui.utils.DlimFileUtils;
import tools.descartes.dlim.presentation.DlimEditor;

public class ExtractionAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection currentSelection;

    protected Shell getShell() {
        return this.shell;
    }

    protected ISelection getCurrentSelection() {
        return this.currentSelection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    public void run(IAction action) {
        Sequence sequence = (Sequence)DlimFileUtils.getEObjectFromSelection((ISelection)this.currentSelection);
        ExtractorHandler handler = ExtractorHandler.getHandlerSingleton();
        SelectExtractorDialog dialog = new SelectExtractorDialog(this.shell, handler.getExtractorLabels());
        dialog.open();
        if (!dialog.wasCanceled()) {
            handler.executeExtension(dialog.getSelectedIndex(), dialog.getArrivalRateFilePath(), sequence, dialog.getOffset());
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof DlimEditor) {
                DlimEditor dlimEditor = (DlimEditor)editor;
                EditingDomain domain = dlimEditor.getEditingDomain();
                SetCommand set = new SetCommand(domain, (EObject)sequence, (EStructuralFeature)DlimPackage.eINSTANCE.getSequence_TerminateAfterLoops(), (Object)sequence.getTerminateAfterLoops());
                domain.getCommandStack().execute((Command)set);
            }
        }
    }
}

