/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.editor.wizards.DlimBurstModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimPageChoiceModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimReadFileModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimSeasonalModelWizardPage;
import tools.descartes.dlim.generator.editor.wizards.DlimTrendModelWizardPage;
import tools.descartes.dlim.presentation.DlimEditorPlugin;
import tools.descartes.dlim.presentation.DlimModelWizard;

public class CustomDlimModelWizard
extends DlimModelWizard {
    private boolean showReadPage = false;
    private boolean showSeasonalPage = true;
    private boolean showTrendPage = true;
    private boolean showBurstPage = true;
    private DlimReadFileModelWizardPage readPage;
    private DlimSeasonalModelWizardPage seasonalPage;
    private DlimTrendModelWizardPage trendPage;
    private DlimBurstModelWizardPage burstPage;
    private DlimPageChoiceModelWizardPage choicePage;
    private Sequence rootObject = this.dlimFactory.createSequence();

    public CustomDlimModelWizard() {
        this.rootObject.setName("");
    }

    @Override
    protected EObject createInitialModel() {
        this.rootObject.setName(this.getModelName());
        return this.rootObject;
    }

    private String getModelName() {
        String[] names = this.newFileCreationPage.getFileName().split("\\.");
        String name = "";
        if (names.length > 1) {
            int i = 0;
            while (i < names.length - 1) {
                name = String.valueOf(name) + "." + names[i];
                ++i;
            }
            return name.substring(1);
        }
        if (names.length == 1) {
            return names[0].trim();
        }
        return this.newFileCreationPage.getFileName();
    }

    @Override
    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new DlimModelWizard.DlimModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(DlimEditorPlugin.INSTANCE.getString("_UI_DlimModelWizard_label"));
        this.newFileCreationPage.setDescription(DlimEditorPlugin.INSTANCE.getString("_UI_DlimModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(DlimEditorPlugin.INSTANCE.getString("_UI_DlimEditorFilenameDefaultBase")) + "." + (String)FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = DlimEditorPlugin.INSTANCE.getString("_UI_DlimEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = (String)FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new DlimModelWizardNullInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(DlimEditorPlugin.INSTANCE.getString("_UI_DlimModelWizard_label"));
        this.initialObjectCreationPage.setDescription(DlimEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.choicePage = new DlimPageChoiceModelWizardPage("choice page");
        this.choicePage.setTitle("Initial Model Parameters");
        this.choicePage.setDescription("Choose the Initial Model Parameters to be set.");
        this.addPage((IWizardPage)this.choicePage);
        this.readPage = new DlimReadFileModelWizardPage("read page", this.rootObject);
        this.readPage.setTitle("Extract Parameters");
        this.readPage.setDescription("Extract Model Parameters from an existing Trace (Optional)");
        this.addPage((IWizardPage)this.readPage);
        this.seasonalPage = new DlimSeasonalModelWizardPage("seasonalPage", this.rootObject);
        this.seasonalPage.setTitle("Seasonal Pattern");
        this.seasonalPage.setDescription("Choose a seasonal pattern for the model");
        this.addPage((IWizardPage)this.seasonalPage);
        this.trendPage = new DlimTrendModelWizardPage("trendPage", this.rootObject);
        this.trendPage.setTitle("Overarching Trends");
        this.trendPage.setDescription("Choose the overarching trends for the model");
        this.addPage((IWizardPage)this.trendPage);
        this.burstPage = new DlimBurstModelWizardPage("burstPage", this.rootObject);
        this.burstPage.setTitle("Recurring Bursts and Noise");
        this.burstPage.setDescription("Set bursts and noise for the model");
        this.addPage((IWizardPage)this.burstPage);
    }

    public DlimPageChoiceModelWizardPage getChoicePage() {
        return this.choicePage;
    }

    public DlimReadFileModelWizardPage getReadPage() {
        return this.readPage;
    }

    public DlimSeasonalModelWizardPage getSeasonalPage() {
        return this.seasonalPage;
    }

    public DlimTrendModelWizardPage getTrendPage() {
        return this.trendPage;
    }

    public DlimBurstModelWizardPage getBurstPage() {
        return this.burstPage;
    }

    public boolean isShowReadPage() {
        return this.showReadPage;
    }

    public void setShowReadPage(boolean showReadPage) {
        this.showReadPage = showReadPage;
    }

    public boolean isShowSeasonalPage() {
        return this.showSeasonalPage;
    }

    public void setShowSeasonalPage(boolean showSeasonalPage) {
        this.showSeasonalPage = showSeasonalPage;
    }

    public boolean isShowTrendPage() {
        return this.showTrendPage;
    }

    public void setShowTrendPage(boolean showTrendPage) {
        this.showTrendPage = showTrendPage;
    }

    public boolean isShowBurstPage() {
        return this.showBurstPage;
    }

    public void setShowBurstPage(boolean showBurstPage) {
        this.showBurstPage = showBurstPage;
    }

    private class DlimModelWizardNullInitialObjectCreationPage
    extends DlimModelWizard.DlimModelWizardInitialObjectCreationPage {
        public DlimModelWizardNullInitialObjectCreationPage(String pageId) {
            super(pageId);
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }
    }
}

