/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiffResultsDialog
extends TitleAreaDialog {
    private double mean = 0.0;
    private double median = 0.0;
    private double dtwDist = 0.0;
    private double meanPercent = 0.0;
    private double medianPercent = 0.0;

    public DiffResultsDialog(Shell parentShell, double mean, double median, double dtwDist, double meanPercent, double medianPercent) {
        super(parentShell);
        this.mean = mean;
        this.median = median;
        this.dtwDist = dtwDist;
        this.meanPercent = meanPercent;
        this.medianPercent = medianPercent;
    }

    public void create() {
        super.create();
        this.setTitle("Difference Calculation Results");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite gridContainer = new Composite(dialogContainer, 0);
        GridLayout layout = new GridLayout(5, false);
        gridContainer.setLayout((Layout)layout);
        this.createValueDisplayField(gridContainer, "Mean Difference: ", "" + this.mean, "" + this.meanPercent * 100.0);
        this.createValueDisplayField(gridContainer, "Median Difference: ", "" + this.median, "" + this.medianPercent * 100.0);
        this.createValueDisplayField(gridContainer, "Normalized Curve Difference (based on DTW): ", "" + this.dtwDist, null);
        return dialogContainer;
    }

    private void createValueDisplayField(Composite container, String labelString, String textString, String percentString) {
        Label parameterFieldLabel = new Label(container, 0);
        parameterFieldLabel.setText(labelString);
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 120;
        Text outputText = new Text(container, 2048);
        outputText.setText(textString);
        outputText.setLayoutData((Object)parameterFieldData);
        outputText.setEditable(false);
        GridData percentFieldData = new GridData();
        percentFieldData.grabExcessHorizontalSpace = false;
        percentFieldData.horizontalAlignment = 1;
        percentFieldData.widthHint = 110;
        if (percentString != null) {
            Label commaLabel = new Label(container, 0);
            commaLabel.setText(",");
            Text percentText = new Text(container, 2048);
            percentText.setText(percentString);
            percentText.setLayoutData((Object)percentFieldData);
            percentText.setEditable(false);
            Label percentLabel = new Label(container, 0);
            percentLabel.setText("%");
        } else {
            int i = 0;
            while (i < 3) {
                Label spaceLabel = new Label(container, 0);
                spaceLabel.setText(" ");
                ++i;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Calculate Difference");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

