/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.extractor.ModelExtractor;
import tools.descartes.dlim.generator.editor.wizards.CustomDlimModelWizard;
import tools.descartes.dlim.generator.editor.wizards.DlimModelWizardPage;

public class DlimReadFileModelWizardPage
extends DlimModelWizardPage {
    private Text offsetText;
    private Text seasonalPeriodText;
    private Text seasonalsPerTrendText;
    private Button extractNoiseButton;
    private Text filePathText;
    private double offset = 0.0;
    private double seasonalPeriod = 24.0;
    private int seasonalsPerTrend = 7;
    private String filePath = "";

    protected DlimReadFileModelWizardPage(String pageName, Sequence rootSequence) {
        super(pageName, rootSequence);
    }

    @Override
    protected void fillInteractiveArea(Composite interactiveArea) {
        GridData parentData = new GridData();
        parentData.horizontalAlignment = 4;
        interactiveArea.setLayoutData((Object)parentData);
        Composite parent = new Composite(interactiveArea, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.createOffsetField(parent);
        this.createSeasonalPeriodField(parent);
        this.createSeasonalsPerTrendField(parent);
        this.createExtractNoiseCheckBox(parent);
        Composite fileSelectionComposite = new Composite(interactiveArea, 0);
        GridLayout formSelectionLayout = new GridLayout(3, false);
        formSelectionLayout.marginWidth = 5;
        formSelectionLayout.marginHeight = 5;
        formSelectionLayout.verticalSpacing = 0;
        formSelectionLayout.horizontalSpacing = 0;
        fileSelectionComposite.setLayout((Layout)formSelectionLayout);
        this.createFileSelectionField(fileSelectionComposite);
    }

    private void createFileSelectionField(Composite fileSelectionComposite) {
        Label parameterFieldLabel = new Label(fileSelectionComposite, 0);
        parameterFieldLabel.setText("Arrival Rate File: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.filePathText = new Text(fileSelectionComposite, 2048);
        this.filePathText.setText(this.filePath);
        this.filePathText.setLayoutData((Object)parameterFieldData);
        this.addValidationListener(this.filePathText);
        Button fileDialogButton = new Button(fileSelectionComposite, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DlimReadFileModelWizardPage.this.getShell(), 4096);
                String[] filterNames = new String[]{"Arrival Rate files", "All Files"};
                String[] filterExtensions = new String[]{"*.csv;*.txt", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Select Arrival Rate File");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    DlimReadFileModelWizardPage.this.filePathText.setText(newPath);
                }
            }
        });
    }

    private void createOffsetField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Model Start Offset: ");
        fieldLabel.setAlignment(131072);
        this.offsetText = new Text(parent, 2048);
        this.offsetText.setText("" + this.offset);
        this.addValidationListener(this.offsetText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.offsetText.setLayoutData((Object)textData);
    }

    private void createSeasonalPeriodField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Seasonal Period: ");
        fieldLabel.setAlignment(131072);
        this.seasonalPeriodText = new Text(parent, 2048);
        this.seasonalPeriodText.setText("" + this.seasonalPeriod);
        this.addValidationListener(this.seasonalPeriodText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.seasonalPeriodText.setLayoutData((Object)textData);
    }

    private void createSeasonalsPerTrendField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Seasonals per Trend: ");
        fieldLabel.setAlignment(131072);
        this.seasonalsPerTrendText = new Text(parent, 2048);
        this.seasonalsPerTrendText.setText("" + this.seasonalsPerTrend);
        this.addValidationListener(this.seasonalsPerTrendText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.seasonalsPerTrendText.setLayoutData((Object)textData);
    }

    private void createExtractNoiseCheckBox(Composite container) {
        Label fieldLabel = new Label(container, 0);
        fieldLabel.setText("          ");
        this.extractNoiseButton = new Button(container, 32);
        this.extractNoiseButton.setText("Extract Noise");
        this.extractNoiseButton.setSelection(false);
        this.extractNoiseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DlimReadFileModelWizardPage.this.setPageComplete(DlimReadFileModelWizardPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DlimReadFileModelWizardPage.this.setPageComplete(DlimReadFileModelWizardPage.this.validatePage());
            }
        });
    }

    @Override
    protected boolean validatePage() {
        this.filePath = this.filePathText.getText();
        if (this.filePath.isEmpty()) {
            this.seasonalPeriodText.setEnabled(false);
            this.seasonalsPerTrendText.setEnabled(false);
            this.offsetText.setEnabled(false);
        } else {
            this.seasonalPeriodText.setEnabled(true);
            this.seasonalsPerTrendText.setEnabled(true);
            this.offsetText.setEnabled(true);
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.filePath.toString()));
                br.close();
            }
            catch (IOException iOException) {
                this.setMessage("Error reading file. Does it exist?", 3);
                return false;
            }
        }
        if (this.seasonalPeriodText.isEnabled()) {
            try {
                this.seasonalPeriod = Double.parseDouble(this.seasonalPeriodText.getText().trim());
                if (this.seasonalPeriod <= 0.0) {
                    this.setMessage("Seasonal Period must be > 0.", 3);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Inter Burst Period must be a number.", 3);
                return false;
            }
        }
        if (this.offsetText.isEnabled()) {
            try {
                this.offset = Double.parseDouble(this.offsetText.getText().trim());
                if (this.offset < 0.0) {
                    this.setMessage("First Burst Offset must not be negative.", 3);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("First Burst Offset must be a number.", 3);
                return false;
            }
        }
        if (this.seasonalsPerTrendText.isEnabled()) {
            try {
                this.seasonalsPerTrend = Integer.parseInt(this.seasonalsPerTrendText.getText().trim());
                if (this.seasonalsPerTrend < 0) {
                    this.setMessage("Maximum Burst Value must be >= 0.", 3);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Maximum Burst Value be an integer number.", 3);
                return false;
            }
        }
        CustomDlimModelWizard wizard = (CustomDlimModelWizard)this.getWizard();
        this.setMessage(this.getDescription());
        if (!this.filePath.isEmpty()) {
            try {
                HLDlimParameterContainer container = ModelExtractor.extractArrivalRateFileIntoParameters((String)this.filePath, (double)this.seasonalPeriod, (double)this.offset, (int)this.seasonalsPerTrend, (String)wizard.getSeasonalPage().getSeasonalShape(), (String)wizard.getTrendPage().getTrendShape(), (String)wizard.getTrendPage().getOperatorLiteral(), (boolean)this.extractNoiseButton.getSelection());
                wizard.getSeasonalPage().fillPageWithHLDlimParameters(container);
                wizard.getTrendPage().fillPageWithHLDlimParameters(container);
                wizard.getBurstPage().fillPageWithHLDlimParameters(container);
            }
            catch (CalibrationException e) {
                this.setMessage("Extraction Error: " + e.getMessage(), 3);
            }
        }
        this.updatePlot();
        return true;
    }

    @Override
    protected void parseParameters(HLDlimParameterContainer container) {
    }
}

