/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;

public class LaunchDiffDialog
extends TitleAreaDialog {
    private static final String DIFF_PREFERENCES = "dlim.diff";
    private Text rndSeedText;
    private Text txtFilePathText;
    private Text offsetText;
    private String txtFilePath = "";
    private int rndSeed = 5;
    private double offset = 0.0;
    private boolean canceled = false;
    private String modelFileString;

    public LaunchDiffDialog(String fileString, Shell parentShell) {
        super(parentShell);
        this.modelFileString = fileString;
    }

    private void setDefaultValues() {
        this.rndSeed = 5;
        this.txtFilePath = "";
    }

    public void create() {
        super.create();
        this.setTitle("Calculate difference between Arrival Rate File and Model");
        this.setMessage("For Model: " + this.modelFileString, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createRndSeedParameterField(columnContainer);
        this.createOffsetParameterField(columnContainer);
        this.createTxtFilePathField(columnContainer);
        return dialogContainer;
    }

    private void createTxtFilePathField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Arrival Rate File: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 300;
        this.txtFilePathText = new Text(gridContainer, 2048);
        this.txtFilePathText.setText(ProjectManager.retrieveStringFromPreferences(DIFF_PREFERENCES));
        this.txtFilePathText.setLayoutData((Object)parameterFieldData);
        Button fileDialogButton = new Button(gridContainer, 8);
        fileDialogButton.setText("Browse");
        fileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LaunchDiffDialog.this.getParentShell(), 4096);
                String[] filterNames = new String[]{"Arrival Rate files", "All Files"};
                String[] filterExtensions = new String[]{"*.csv;*.txt", "*.*"};
                dialog.setFilterNames(filterNames);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setText("Select Arrival Rate File");
                String newPath = dialog.open();
                if (newPath != null && !newPath.isEmpty()) {
                    LaunchDiffDialog.this.txtFilePathText.setText(newPath);
                }
            }
        });
    }

    private void createRndSeedParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Random Generator Seed: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.rndSeedText = new Text(gridContainer, 2048);
        this.rndSeedText.setText(String.valueOf(this.rndSeed));
        this.rndSeedText.setLayoutData((Object)parameterFieldData);
    }

    private void createOffsetParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Model start offset within arrival rate file: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 40;
        this.offsetText = new Text(gridContainer, 2048);
        this.offsetText.setText(String.valueOf(this.offset));
        this.offsetText.setLayoutData((Object)parameterFieldData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Calculate Difference");
    }

    protected void cancelPressed() {
        this.setDefaultValues();
        this.canceled = true;
        super.cancelPressed();
    }

    public String getTxtFilePath() {
        return this.txtFilePath;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.rndSeed = Integer.parseInt(this.rndSeedText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Random Seed must be an Integer.", 3);
            error = true;
        }
        try {
            this.offset = Double.parseDouble(this.offsetText.getText().trim());
            if (this.offset < 0.0) {
                this.setMessage("Offset must not be negative.", 3);
                error = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Offset must be a number.", 3);
            error = true;
        }
        this.txtFilePath = this.txtFilePathText.getText().trim();
        Path filePath = new Path(this.txtFilePath);
        try {
            BufferedReader br = new BufferedReader(new FileReader(filePath.toString()));
            br.close();
        }
        catch (IOException iOException) {
            this.setMessage("Error reading file. Does it exist?", 3);
            error = true;
        }
        if (!error) {
            ProjectManager.saveStringToPreferences(DIFF_PREFERENCES, this.txtFilePath);
            this.txtFilePath = filePath.toString();
            super.okPressed();
        }
    }

    public int getRndSeed() {
        return this.rndSeed;
    }

    public double getOffset() {
        return this.offset;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }
}

