/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.Burst;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.UniformNoise;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.generator.editor.wizards.DlimModelWizardPage;

public class DlimBurstModelWizardPage
extends DlimModelWizardPage {
    private Text offsetText;
    private Text periodText;
    private Text peakText;
    private Text widthText;
    private Text noiseMinText;
    private Text noiseMaxText;
    private Combo shapeCombo;
    private Button toggleDecompositionButton;
    private double offset = 36.0;
    private double period = 48.0;
    private double peak = 0.0;
    private double width = 0.0;
    private double noiseMin = 0.0;
    private double noiseMax = 0.0;
    private Combinator burstCombinator;
    private Combinator noiseCombinator;

    protected DlimBurstModelWizardPage(String pageName, Sequence rootSequence) {
        super(pageName, rootSequence);
    }

    @Override
    protected void fillInteractiveArea(Composite interactiveArea) {
        GridData parentData = new GridData();
        parentData.horizontalAlignment = 4;
        interactiveArea.setLayoutData((Object)parentData);
        this.createDelimiterLabel("    Recurring Bursts:", interactiveArea);
        Composite parent = new Composite(interactiveArea, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.createBurstOffsetField(parent);
        this.createBurstPeriodField(parent);
        this.createBurstPeakField(parent);
        this.createBurstWidthField(parent);
        Composite formSelectionComposite = new Composite(interactiveArea, 0);
        GridLayout formSelectionLayout = new GridLayout(2, false);
        formSelectionLayout.marginWidth = 5;
        formSelectionLayout.marginHeight = 5;
        formSelectionLayout.verticalSpacing = 0;
        formSelectionLayout.horizontalSpacing = 0;
        formSelectionComposite.setLayout((Layout)formSelectionLayout);
        this.createFormSelectionField(formSelectionComposite);
        this.createDelimiterLabel(" ", interactiveArea);
        this.createDelimiterLabel("    Noise:", interactiveArea);
        Composite noise = new Composite(interactiveArea, 0);
        GridLayout noiseLayout = new GridLayout(4, false);
        noiseLayout.marginWidth = 5;
        noiseLayout.marginHeight = 5;
        noiseLayout.verticalSpacing = 2;
        noiseLayout.horizontalSpacing = 0;
        noise.setLayout((Layout)gridLayout);
        this.createNoiseMinField(noise);
        this.createNoiseMaxField(noise);
        Label noiseHint = new Label(interactiveArea, 0);
        noiseHint.setText("    Other Noises (such as Gaussian Noise) can easily be added in the EMF editor.");
        Composite toggleDecompositionComposite = new Composite(interactiveArea, 0);
        GridLayout decompositionLayout = new GridLayout(1, false);
        decompositionLayout.marginWidth = 5;
        decompositionLayout.marginHeight = 5;
        decompositionLayout.verticalSpacing = 0;
        decompositionLayout.horizontalSpacing = 0;
        toggleDecompositionComposite.setLayout((Layout)decompositionLayout);
        this.createDecompositionButton(toggleDecompositionComposite);
    }

    private void createDelimiterLabel(String text, Composite parent) {
        Label delimiterLabel = new Label(parent, 0);
        delimiterLabel.setText(text);
        delimiterLabel.setAlignment(131072);
        delimiterLabel.setFont(JFaceResources.getFontRegistry().getBold(""));
    }

    private void createBurstOffsetField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("First Burst Offset: ");
        fieldLabel.setAlignment(131072);
        this.offsetText = new Text(parent, 2048);
        this.offsetText.setText("" + this.offset);
        this.addValidationListener(this.offsetText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.offsetText.setLayoutData((Object)textData);
    }

    private void createBurstPeriodField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Inter Burst Period: ");
        fieldLabel.setAlignment(131072);
        this.periodText = new Text(parent, 2048);
        this.periodText.setText("" + this.period);
        this.addValidationListener(this.periodText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.periodText.setLayoutData((Object)textData);
    }

    private void createBurstPeakField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Burst Peak Arrival Rate: ");
        fieldLabel.setAlignment(131072);
        this.peakText = new Text(parent, 2048);
        this.peakText.setText("" + this.peak);
        this.addValidationListener(this.peakText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.peakText.setLayoutData((Object)textData);
    }

    private void createBurstWidthField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Burst Width: ");
        fieldLabel.setAlignment(131072);
        this.widthText = new Text(parent, 2048);
        this.widthText.setText("" + this.width);
        this.addValidationListener(this.widthText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.widthText.setLayoutData((Object)textData);
    }

    private void createFormSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Select Burst Shape: ");
        fieldLabel.setAlignment(131072);
        this.shapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 220;
        this.shapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitiaBurstNames()) {
            this.shapeCombo.add(name);
        }
        this.shapeCombo.select(0);
        this.addValidationListener(this.shapeCombo);
    }

    private Collection<String> getInitiaBurstNames() {
        ArrayList<String> initialObjectNames = new ArrayList<String>();
        for (EClassifier eClassifier : DlimPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !DlimPackage.eINSTANCE.getBurst().isSuperTypeOf(eClass)) continue;
            initialObjectNames.add(eClass.getName());
        }
        Collections.sort(initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        return initialObjectNames;
    }

    private void createNoiseMinField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Minimum Noise Arrival Rate: ");
        fieldLabel.setAlignment(131072);
        this.noiseMinText = new Text(parent, 2048);
        this.noiseMinText.setText("" + this.noiseMin);
        this.addValidationListener(this.noiseMinText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.noiseMinText.setLayoutData((Object)textData);
    }

    private void createNoiseMaxField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Maximum Noise Arrival Rate: ");
        fieldLabel.setAlignment(131072);
        this.noiseMaxText = new Text(parent, 2048);
        this.noiseMaxText.setText("" + this.noiseMax);
        this.addValidationListener(this.noiseMaxText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.noiseMaxText.setLayoutData((Object)textData);
    }

    private void createDecompositionButton(Composite parent) {
        GridData parentData = new GridData();
        parentData.grabExcessHorizontalSpace = true;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        parentData.verticalAlignment = 4;
        parent.setLayoutData((Object)parentData);
        this.toggleDecompositionButton = new Button(parent, 32);
        this.toggleDecompositionButton.setText("Explicitly show Trend, Burst, and Noise Contributions in Plot");
        this.toggleDecompositionButton.setSelection(true);
        this.toggleDecompositionButton.setLayoutData((Object)new GridData(131072, 128, true, true, 1, 1));
        this.getDlimPlotter().setDecompositionMode(true);
        this.toggleDecompositionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DlimBurstModelWizardPage.this.getDlimPlotter().setDecompositionMode(DlimBurstModelWizardPage.this.toggleDecompositionButton.getSelection());
                DlimBurstModelWizardPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DlimBurstModelWizardPage.this.getDlimPlotter().setDecompositionMode(DlimBurstModelWizardPage.this.toggleDecompositionButton.getSelection());
                DlimBurstModelWizardPage.this.validatePage();
            }
        });
    }

    @Override
    protected boolean validatePage() {
        block20: {
            block19: {
                try {
                    this.period = Double.parseDouble(this.periodText.getText().trim());
                    if (this.period <= 0.0) {
                        this.setMessage("Inter Burst Period must be > 0.", 3);
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessage("Inter Burst Period must be a number.", 3);
                    return false;
                }
                try {
                    this.offset = Double.parseDouble(this.offsetText.getText().trim());
                    if (this.offset <= 0.0) {
                        this.setMessage("First Burst Offset must be > 0.", 3);
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessage("First Burst Offset must be a number.", 3);
                    return false;
                }
                try {
                    this.peak = Double.parseDouble(this.peakText.getText().trim());
                    if (this.peak < 0.0) {
                        this.setMessage("Maximum Burst Value must be >= 0.", 3);
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessage("Maximum Burst Value be a number.", 3);
                    return false;
                }
                try {
                    this.width = Double.parseDouble(this.widthText.getText().trim());
                    if (!(this.width < 0.0)) break block19;
                    this.setMessage("Burst Width must be >= 0.", 3);
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessage("Maximum Burst Value be a number.", 3);
                    return false;
                }
            }
            if (this.width == 0.0 || !(this.width > this.period)) break block20;
            this.setMessage("Burst Width must not be greater than the Inter Burst Period.", 3);
            return false;
        }
        if (this.width != 0.0 && this.width > this.offset * 2.0) {
            this.setMessage("Burst Width must not be greater than 2*Offset.", 3);
            return false;
        }
        try {
            this.noiseMin = Double.parseDouble(this.noiseMinText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Noise Minimum Value must be a number.", 3);
            return false;
        }
        try {
            this.noiseMax = Double.parseDouble(this.noiseMaxText.getText().trim());
            if (this.noiseMax < this.noiseMin) {
                this.setMessage("Noise Maximum Value must be greater than Noise Minimum Value.", 3);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Noise Maximum Value must be a number.", 3);
            return false;
        }
        this.setMessage(this.getDescription());
        this.populateModel();
        this.updatePlot();
        return true;
    }

    private void populateModel() {
        this.getRootSequence().getCombine().remove((Object)this.burstCombinator);
        DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
        try {
            if (this.width > 0.0 && this.peak > 0.0) {
                Sequence burstSequence;
                this.burstCombinator = factory.createCombinator();
                Sequence burstContainerSequence = factory.createSequence();
                burstContainerSequence.setName("burstContainer");
                burstContainerSequence.setTerminateAfterTime(this.getRootSequence().getFinalDuration());
                this.burstCombinator.setFunction((Function)burstContainerSequence);
                if (this.offset - this.width / 2.0 == 0.0) {
                    burstSequence = burstContainerSequence;
                } else {
                    burstSequence = factory.createSequence();
                    TimeDependentFunctionContainer offsetElement = factory.createTimeDependentFunctionContainer();
                    offsetElement.setName("burstOffset");
                    offsetElement.setDuration(this.offset - this.width / 2.0);
                    burstContainerSequence.getSequenceFunctionContainers().add((Object)offsetElement);
                    TimeDependentFunctionContainer burstElement = factory.createTimeDependentFunctionContainer();
                    burstElement.setName("bursts");
                    burstElement.setDuration(this.getRootSequence().getFinalDuration() - (this.offset - this.width / 2.0));
                    burstContainerSequence.getSequenceFunctionContainers().add((Object)burstElement);
                    burstSequence.setTerminateAfterTime(burstElement.getDuration());
                    burstElement.setFunction((Function)burstSequence);
                }
                burstSequence.setName("bursts");
                TimeDependentFunctionContainer burstElement = factory.createTimeDependentFunctionContainer();
                burstElement.setName("burst");
                burstElement.setDuration(this.width);
                Burst burst = (Burst)factory.create((EClass)DlimPackage.eINSTANCE.getEClassifier(this.shapeCombo.getText().trim()));
                burst.setBase(0.0);
                burst.setPeakTime(this.width / 2.0);
                burst.setPeak(this.peak);
                burstElement.setFunction((Function)burst);
                burstSequence.getSequenceFunctionContainers().add((Object)burstElement);
                TimeDependentFunctionContainer waitElement = factory.createTimeDependentFunctionContainer();
                waitElement.setName("wait");
                waitElement.setDuration(this.period - this.width);
                burstSequence.getSequenceFunctionContainers().add((Object)waitElement);
                this.getRootSequence().getCombine().add((Object)this.burstCombinator);
            }
        }
        catch (NullPointerException nullPointerException) {}
        this.getRootSequence().getCombine().remove((Object)this.noiseCombinator);
        if (this.noiseMin != 0.0 || this.noiseMax != 0.0) {
            this.noiseCombinator = factory.createCombinator();
            UniformNoise noise = factory.createUniformNoise();
            noise.setMin(this.noiseMin);
            noise.setMax(this.noiseMax);
            this.noiseCombinator.setFunction((Function)noise);
            this.getRootSequence().getCombine().add((Object)this.noiseCombinator);
        }
    }

    @Override
    protected void parseParameters(HLDlimParameterContainer container) {
        this.offsetText.setText("" + container.getBurstOffset());
        this.periodText.setText("" + container.getBurstPeriod());
        this.peakText.setText("" + container.getBurstPeak());
        this.widthText.setText("" + container.getBurstWidth());
        this.noiseMinText.setText("" + container.getNoiseMin());
        this.noiseMaxText.setText("" + container.getNoiseMax());
        this.offset = container.getBurstOffset();
        this.period = container.getBurstPeriod();
        this.peak = container.getBurstPeak();
        this.width = container.getBurstWidth();
        this.noiseMin = container.getNoiseMin();
        this.noiseMax = container.getNoiseMax();
    }
}

