/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.ModelEvaluator;

public class ArrivalRateTimeStampParametersDialog
extends TitleAreaDialog {
    private Text stepText;
    private Text rndSeedText;
    private int rndSeed = 5;
    private double step = 1.0;
    private boolean canceled = false;
    private ModelEvaluator evaluator;
    private String fileString;

    public ArrivalRateTimeStampParametersDialog(ModelEvaluator evaluator, String fileString, Shell parentShell) {
        super(parentShell);
        this.fileString = fileString;
        this.evaluator = evaluator;
    }

    private void setDefaultValues() {
        this.rndSeed = 5;
        this.step = 1.0;
        this.canceled = false;
    }

    public void create() {
        super.create();
        this.setTitle("Arrival Rate Time Stamp Generation Parameters");
        this.setMessage("For Model: " + this.fileString, 1);
        if (this.evaluator.getDuration() >= Double.MAX_VALUE) {
            this.setMessage("Model has infinite duration. Terminating after first loop!", 2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createStepParameterField(columnContainer);
        this.createRndSeedParameterField(columnContainer);
        return dialogContainer;
    }

    private void createRndSeedParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Random Generator Seed: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.rndSeedText = new Text(gridContainer, 2048);
        this.rndSeedText.setText("5");
        this.rndSeedText.setLayoutData((Object)parameterFieldData);
    }

    private void createStepParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Sampling Interval Width: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 20;
        this.stepText = new Text(gridContainer, 2048);
        this.stepText.setText("1.0");
        this.stepText.setLayoutData((Object)parameterFieldData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Arrival Rate Time Stamp Generation Parameters");
    }

    protected void cancelPressed() {
        this.setDefaultValues();
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.step = Double.parseDouble(this.stepText.getText().trim());
        }
        catch (NumberFormatException e) {
            this.setMessage("Sampling Interval Width must be a number.", 3);
            error = true;
        }
        try {
            this.rndSeed = Integer.parseInt(this.rndSeedText.getText().trim());
        }
        catch (NumberFormatException e) {
            this.setMessage("Random Seed must be an Integer.", 3);
            error = true;
        }
        if (this.step <= 0.0) {
            error = true;
            this.setMessage("Sampling Interval Width must greater than 0.", 3);
        }
        if (!error) {
            super.okPressed();
        }
    }

    public int getRndSeed() {
        return this.rndSeed;
    }

    public double getStep() {
        return this.step;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }
}

