/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.ui.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class DlimFileUtils {
    private DlimFileUtils() {
    }

    public static EObject getEObjectFromSelection(ISelection selectedResource) {
        if (!(selectedResource instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selectedResource;
        Object modelElement = structuredSelection.getFirstElement();
        if (modelElement instanceof EObject) {
            return (EObject)modelElement;
        }
        return null;
    }

    public static IResource getResourceFromSelection(ISelection selectedResource) {
        if (!(selectedResource instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selectedResource;
        Object resourceElement = structuredSelection.getFirstElement();
        if (resourceElement instanceof IResource) {
            return (IResource)resourceElement;
        }
        if (!(resourceElement instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)resourceElement;
        Object adapter = adaptable.getAdapter(IResource.class);
        return (IResource)adapter;
    }

    public static List<IResource> getResourceListFromSelection(ISelection selectedResource) {
        ArrayList<IResource> resourceList = new ArrayList<IResource>();
        if (!(selectedResource instanceof IStructuredSelection)) {
            return resourceList;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selectedResource;
        for (Object resourceElement : structuredSelection.toList()) {
            if (!(resourceElement instanceof IResource)) continue;
            resourceList.add((IResource)resourceElement);
        }
        return resourceList;
    }

    public static String getSelectionPath(ISelection selectedResource) {
        IResource resource = DlimFileUtils.getResourceFromSelection(selectedResource);
        return resource.getRawLocation().toString();
    }

    public static EObject getRootEObject(ISelection selectedResource) {
        IResource resource = DlimFileUtils.getResourceFromSelection(selectedResource);
        URI fileURI = URI.createFileURI((String)resource.getLocation().toString());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("dlim", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource dlimResource = resourceSet.getResource(fileURI, true);
        return (EObject)dlimResource.getContents().get(0);
    }

    public static EObject getRootEObject(IResource resource) {
        URI fileURI = URI.createFileURI((String)resource.getLocation().toString());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("dlim", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource dlimResource = resourceSet.getResource(fileURI, true);
        return (EObject)dlimResource.getContents().get(0);
    }
}

