/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.assistant;

import tools.descartes.dlim.Burst;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.generator.ModelEvaluator;
import tools.descartes.dlim.generator.ModelEvaluatorUtil;

public final class Calibrator {
    private static final double EPSILON = 1.0E-15;
    private static final double MAXCALIBRATIONERROR = 1.0E-5;

    private Calibrator() {
    }

    public static double calibrateTrendStartValue(double desiredValue, Trend trend, ModelEvaluator evaluator) throws CalibrationException {
        double oldValue = trend.getFunctionOutputAtStart();
        double time = ModelEvaluatorUtil.getFunctionBegin((Function)trend);
        trend.setFunctionOutputAtStart(0.0);
        double f0 = evaluator.getArrivalRateAtTime(time);
        trend.setFunctionOutputAtStart(1.0);
        double f1 = evaluator.getArrivalRateAtTime(time);
        if (f1 == f0) {
            throw new CalibrationException("Trend is not being executed at the time at which its startValue is defined.");
        }
        double newValue = (desiredValue - f0) / (f1 - f0);
        trend.setFunctionOutputAtStart(newValue);
        if (evaluator.getArrivalRateAtTime(time) - desiredValue > 1.0E-5) {
            trend.setFunctionOutputAtStart(oldValue);
            throw new CalibrationException("Calibration returned incorrect value. Is this Trend an (indirect) child of a UnivariateFuncion?");
        }
        trend.setFunctionOutputAtStart(oldValue);
        return newValue;
    }

    public static double calibrateTrendEndValue(double desiredValue, Trend trend, ModelEvaluator evaluator) throws CalibrationException {
        double end;
        double oldValue = trend.getFunctionOutputAtEnd();
        double time = end = ModelEvaluatorUtil.getFunctionBegin((Function)trend) + ModelEvaluatorUtil.getFunctionDuration((Function)trend);
        double epsilon = 1.0E-15;
        while (end == time) {
            time -= epsilon;
            epsilon *= 2.0;
        }
        trend.setFunctionOutputAtEnd(0.0);
        double f0 = evaluator.getArrivalRateAtTime(time);
        trend.setFunctionOutputAtEnd(1.0);
        double f1 = evaluator.getArrivalRateAtTime(time);
        if (f1 == f0) {
            throw new CalibrationException("Trend is not being executed at the time at which its endValue is defined.");
        }
        double newValue = (desiredValue - f0) / (f1 - f0);
        trend.setFunctionOutputAtEnd(newValue);
        if (evaluator.getArrivalRateAtTime(time) - desiredValue > 1.0E-5) {
            trend.setFunctionOutputAtEnd(oldValue);
            throw new CalibrationException("Calibration returned incorrect value. Is this Trend an (indirect) child of a UnivariateFuncion?");
        }
        trend.setFunctionOutputAtEnd(oldValue);
        return newValue;
    }

    public static double calibrateBurstPeakValue(double desiredValue, Burst burst, ModelEvaluator evaluator) throws CalibrationException {
        double oldValue = burst.getPeak();
        double time = ModelEvaluatorUtil.getFunctionBegin((Function)burst) + burst.getPeakTime();
        burst.setPeak(0.0);
        double f0 = evaluator.getArrivalRateAtTime(time);
        burst.setPeak(1.0);
        double f1 = evaluator.getArrivalRateAtTime(time);
        if (f1 == f0) {
            throw new CalibrationException("Burst is not being executed at the time at which its peakValue is defined.");
        }
        double newValue = (desiredValue - f0) / (f1 - f0);
        burst.setPeak(newValue);
        if (evaluator.getArrivalRateAtTime(time) - desiredValue > 1.0E-5) {
            burst.setPeak(oldValue);
            throw new CalibrationException("Calibration returned incorrect value. Is this Burst an (indirect) child of a UnivariateFuncion?");
        }
        burst.setPeak(oldValue);
        return newValue;
    }
}

